/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.cache;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.sf.ehcache.CacheException;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.config.CacheConfiguration;
import net.sf.ehcache.config.Configuration;
import net.sf.ehcache.config.ConfigurationFactory;
import org.apache.cxf.Bus;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.ws.security.cache.EHCacheReplayCacheFactory;

public final class EHCacheManagerHolder {
    public static final String GLOBAL_EHCACHE_MANAGER_NAME = "ws-security.global.ehcachemanager";
    private static final ConcurrentHashMap<String, AtomicInteger> COUNTS = new ConcurrentHashMap(8, 0.75f, 2);
    private static Method cacheManagerCreateMethodNoArg;
    private static Method createMethodURLArg;
    private static Method cacheManagerCreateMethodConfigurationArg;

    private EHCacheManagerHolder() {
    }

    public static CacheConfiguration getCacheConfiguration(String key, CacheManager cacheManager) {
        CacheConfiguration cc = (CacheConfiguration)cacheManager.getConfiguration().getCacheConfigurations().get(key);
        if (cc == null && key.contains("-")) {
            cc = (CacheConfiguration)cacheManager.getConfiguration().getCacheConfigurations().get(key.substring(0, key.lastIndexOf(45)));
        }
        if (cc == null) {
            cc = cacheManager.getConfiguration().getDefaultCacheConfiguration();
        }
        cc = cc == null ? new CacheConfiguration() : cc.clone();
        cc.setName(key);
        return cc;
    }

    public static CacheManager getCacheManager(Bus bus, URL configFileURL) {
        CacheManager cacheManager = null;
        String globalCacheManagerName = EHCacheManagerHolder.getGlobalCacheManagerName(bus);
        if (globalCacheManagerName != null) {
            cacheManager = CacheManager.getCacheManager((String)globalCacheManagerName);
        }
        if (cacheManager == null) {
            AtomicInteger a;
            if (configFileURL == null) {
                cacheManager = EHCacheManagerHolder.findDefaultCacheManager(bus);
            }
            if (cacheManager == null) {
                cacheManager = configFileURL == null ? EHCacheManagerHolder.createCacheManager() : EHCacheManagerHolder.createCacheManager(configFileURL);
            }
            if ((a = COUNTS.get(cacheManager.getName())) == null) {
                COUNTS.putIfAbsent(cacheManager.getName(), new AtomicInteger());
                a = COUNTS.get(cacheManager.getName());
            }
            if (a.incrementAndGet() == 1) {
                // empty if block
            }
        }
        return cacheManager;
    }

    private static String getGlobalCacheManagerName(Bus bus) {
        if (bus != null) {
            return (String)bus.getProperty(GLOBAL_EHCACHE_MANAGER_NAME);
        }
        return null;
    }

    private static CacheManager findDefaultCacheManager(Bus bus) {
        String defaultConfigFile = "cxf-ehcache.xml";
        URL configFileURL = null;
        String busId = "";
        if (bus != null) {
            ResourceManager rm = bus.getExtension(ResourceManager.class);
            configFileURL = rm.resolveResource(defaultConfigFile, URL.class);
            busId = bus.getId();
        }
        try {
            if (configFileURL == null) {
                configFileURL = ClassLoaderUtils.getResource(defaultConfigFile, EHCacheReplayCacheFactory.class);
            }
            if (configFileURL == null) {
                configFileURL = new URL(defaultConfigFile);
            }
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            Configuration conf = ConfigurationFactory.parseConfiguration(configFileURL);
            conf.setName(busId);
            if ("java.io.tmpdir".equals(conf.getDiskStoreConfiguration().getOriginalPath())) {
                String path = conf.getDiskStoreConfiguration().getPath() + File.separator + busId;
                conf.getDiskStoreConfiguration().setPath(path);
            }
            return EHCacheManagerHolder.createCacheManager(conf);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static void releaseCacheManger(CacheManager cacheManager) {
        AtomicInteger a = COUNTS.get(cacheManager.getName());
        if (a == null) {
            return;
        }
        if (a.decrementAndGet() == 0) {
            cacheManager.shutdown();
        }
    }

    static CacheManager createCacheManager() throws CacheException {
        try {
            return (CacheManager)cacheManagerCreateMethodNoArg.invoke(null, (Object[])null);
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    static CacheManager createCacheManager(URL url) throws CacheException {
        try {
            return (CacheManager)createMethodURLArg.invoke(null, url);
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    static CacheManager createCacheManager(Configuration conf) throws CacheException {
        try {
            return (CacheManager)cacheManagerCreateMethodConfigurationArg.invoke(null, conf);
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    static {
        try {
            cacheManagerCreateMethodNoArg = CacheManager.class.getMethod("newInstance", null);
            createMethodURLArg = CacheManager.class.getMethod("newInstance", URL.class);
            cacheManagerCreateMethodConfigurationArg = CacheManager.class.getMethod("newInstance", Configuration.class);
        }
        catch (NoSuchMethodException e) {
            try {
                cacheManagerCreateMethodNoArg = CacheManager.class.getMethod("create", null);
                createMethodURLArg = CacheManager.class.getMethod("create", URL.class);
                cacheManagerCreateMethodConfigurationArg = CacheManager.class.getMethod("create", Configuration.class);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

