/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.ext.search.jpa;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import javax.persistence.EntityManager;
import javax.persistence.TypedQuery;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import org.apache.cxf.jaxrs.ext.search.AbstractSearchConditionVisitor;
import org.apache.cxf.jaxrs.ext.search.ConditionType;
import org.apache.cxf.jaxrs.ext.search.OrSearchCondition;
import org.apache.cxf.jaxrs.ext.search.PrimitiveStatement;
import org.apache.cxf.jaxrs.ext.search.SearchCondition;

public abstract class AbstractJPATypedQueryVisitor<T, T1, E>
extends AbstractSearchConditionVisitor<T, E> {
    private EntityManager em;
    private Class<T> tClass;
    private Class<T1> queryClass;
    private Root<T> root;
    private CriteriaBuilder builder;
    private CriteriaQuery<T1> cq;
    private Stack<List<Predicate>> predStack = new Stack();
    private boolean criteriaFinalized;
    private Set<String> joinProperties;

    protected AbstractJPATypedQueryVisitor(EntityManager em, Class<T> tClass) {
        this(em, tClass, null, null, null);
    }

    protected AbstractJPATypedQueryVisitor(EntityManager em, Class<T> tClass, Class<T1> queryClass) {
        this(em, tClass, queryClass, null, null);
    }

    protected AbstractJPATypedQueryVisitor(EntityManager em, Class<T> tClass, Map<String, String> fieldMap) {
        this(em, tClass, null, fieldMap, null);
    }

    protected AbstractJPATypedQueryVisitor(EntityManager em, Class<T> tClass, List<String> joinProps) {
        this(em, tClass, null, null, joinProps);
    }

    protected AbstractJPATypedQueryVisitor(EntityManager em, Class<T> tClass, Map<String, String> fieldMap, List<String> joinProps) {
        this(em, tClass, null, fieldMap, joinProps);
    }

    protected AbstractJPATypedQueryVisitor(EntityManager em, Class<T> tClass, Class<T1> queryClass, Map<String, String> fieldMap) {
        this(em, tClass, queryClass, fieldMap, null);
    }

    protected AbstractJPATypedQueryVisitor(EntityManager em, Class<T> tClass, Class<T1> queryClass, Map<String, String> fieldMap, List<String> joinProps) {
        super(fieldMap);
        this.em = em;
        this.tClass = tClass;
        this.queryClass = AbstractJPATypedQueryVisitor.toQueryClass(queryClass, tClass);
        this.joinProperties = joinProps == null ? null : new HashSet<String>(joinProps);
    }

    private static <E> Class<E> toQueryClass(Class<E> queryClass, Class<?> tClass) {
        return queryClass != null ? queryClass : tClass;
    }

    protected EntityManager getEntityManager() {
        return this.em;
    }

    @Override
    public void visit(SearchCondition<T> sc) {
        PrimitiveStatement statement;
        if (this.builder == null) {
            this.builder = this.em.getCriteriaBuilder();
            this.cq = this.builder.createQuery(this.queryClass);
            this.root = this.cq.from(this.tClass);
            this.predStack.push(new ArrayList());
        }
        if ((statement = sc.getStatement()) != null) {
            if (statement.getProperty() != null) {
                this.predStack.peek().add(this.buildPredicate(sc.getConditionType(), statement.getProperty(), statement.getValue(), statement.getValueType()));
            }
        } else {
            this.predStack.push(new ArrayList());
            for (SearchCondition<T> condition : sc.getSearchConditions()) {
                condition.accept(this);
            }
            List<Predicate> predsList = this.predStack.pop();
            Predicate[] preds = predsList.toArray(new Predicate[predsList.size()]);
            Predicate newPred = sc instanceof OrSearchCondition ? this.builder.or(preds) : this.builder.and(preds);
            this.predStack.peek().add(newPred);
        }
    }

    protected CriteriaBuilder getCriteriaBuilder() {
        return this.builder;
    }

    protected Class<T1> getQueryClass() {
        return this.queryClass;
    }

    public Root<T> getRoot() {
        return this.root;
    }

    public TypedQuery<T1> getTypedQuery() {
        return this.em.createQuery(this.getCriteriaQuery());
    }

    public CriteriaQuery<T1> getCriteriaQuery() {
        if (!this.criteriaFinalized) {
            List<Predicate> predsList = this.predStack.pop();
            this.cq.where(predsList.toArray(new Predicate[predsList.size()]));
            this.criteriaFinalized = true;
        }
        return this.cq;
    }

    private Predicate buildPredicate(ConditionType ct, String name, Object value, Type valueType) {
        name = super.getRealPropertyName(name);
        AbstractSearchConditionVisitor.ClassValue cv = this.getPrimitiveFieldClass(name, value.getClass(), valueType, value);
        Class<?> clazz = cv.getCls();
        value = cv.getValue();
        Path<T> path = this.getPath((Path<?>)this.root, name, cv);
        if (this.tClass != this.queryClass) {
            path.alias(name);
        }
        Predicate pred = null;
        switch (ct) {
            case GREATER_THAN: {
                pred = this.builder.greaterThan(path.as(clazz), (Comparable)clazz.cast(value));
                break;
            }
            case EQUALS: {
                if (clazz.equals(String.class)) {
                    String theValue = value.toString();
                    if (theValue.contains("*")) {
                        theValue = ((String)value).replaceAll("\\*", "");
                    }
                    pred = this.builder.like(path.as(String.class), "%" + theValue + "%");
                    break;
                }
                pred = this.builder.equal(path.as(clazz), clazz.cast(value));
                break;
            }
            case NOT_EQUALS: {
                pred = this.builder.notEqual(path.as(clazz), clazz.cast(value));
                break;
            }
            case LESS_THAN: {
                pred = this.builder.lessThan(path.as(clazz), (Comparable)clazz.cast(value));
                break;
            }
            case LESS_OR_EQUALS: {
                pred = this.builder.lessThanOrEqualTo(path.as(clazz), (Comparable)clazz.cast(value));
                break;
            }
            case GREATER_OR_EQUALS: {
                pred = this.builder.greaterThanOrEqualTo(path.as(clazz), (Comparable)clazz.cast(value));
                break;
            }
        }
        return pred;
    }

    private Path<?> getPath(Path<?> element, String name, AbstractSearchConditionVisitor.ClassValue cv) {
        if (name.contains(".")) {
            String pre = name.substring(0, name.indexOf(46));
            String post = name.substring(name.indexOf(46) + 1);
            return this.getPath(this.getNextPath(element, pre, cv), post, cv);
        }
        return this.getNextPath(element, name, cv);
    }

    private Path<?> getNextPath(Path<?> element, String name, AbstractSearchConditionVisitor.ClassValue cv) {
        if ((cv.isCollection(name) || this.isJoinProperty(name)) && (element == this.root || element instanceof Join)) {
            return element == this.root ? this.root.join(name) : ((Join)element).join(name);
        }
        return element.get(name);
    }

    private boolean isJoinProperty(String prop) {
        return this.joinProperties == null ? false : this.joinProperties.contains(prop);
    }
}

