/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.type.basic;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.cxf.aegis.DatabindingException;
import org.apache.cxf.aegis.type.AegisType;
import org.apache.cxf.aegis.type.TypeCreator;
import org.apache.cxf.aegis.type.TypeMapping;
import org.apache.cxf.common.util.ReflectionUtil;

public class BeanTypeInfo {
    private Map<QName, QName> mappedName2typeName = new HashMap<QName, QName>();
    private Map<QName, String> mappedName2pdName = new HashMap<QName, String>();
    private Map<QName, AegisType> mappedName2type = new HashMap<QName, AegisType>();
    private Class<?> beanClass;
    private List<QName> attributes = new ArrayList<QName>();
    private List<QName> elements = new ArrayList<QName>();
    private PropertyDescriptor[] descriptors;
    private TypeMapping typeMapping;
    private volatile boolean initialized;
    private String defaultNamespace;
    private int minOccurs;
    private boolean nillable = true;
    private boolean isExtension;
    private boolean qualifyAttributes;
    private boolean qualifyElements = true;
    private boolean extensibleElements = true;
    private boolean extensibleAttributes = true;

    public BeanTypeInfo(Class<?> typeClass, String defaultNamespace) {
        this.beanClass = typeClass;
        this.defaultNamespace = defaultNamespace;
        this.initializeProperties();
    }

    public BeanTypeInfo(Class<?> typeClass, String defaultNamespace, boolean initialize) {
        this.beanClass = typeClass;
        this.defaultNamespace = defaultNamespace;
        this.initializeProperties();
        this.initialized = !initialize;
    }

    public String getDefaultNamespace() {
        return this.defaultNamespace;
    }

    public void initialize() {
        try {
            if (!this.initialized) {
                this.initializeSync();
            }
        }
        catch (Exception e) {
            if (e instanceof DatabindingException) {
                throw (DatabindingException)e;
            }
            throw new DatabindingException("Couldn't create TypeInfo.", (Throwable)e);
        }
    }

    private synchronized void initializeSync() {
        if (!this.initialized) {
            for (int i = 0; i < this.descriptors.length; ++i) {
                if (!this.isMapped(this.descriptors[i])) continue;
                this.mapProperty(this.descriptors[i]);
            }
            this.initialized = true;
        }
    }

    public boolean isMapped(PropertyDescriptor pd) {
        return pd.getReadMethod() != null;
    }

    protected void mapProperty(PropertyDescriptor pd) {
        String name = pd.getName();
        if (this.isAttribute(pd)) {
            this.mapAttribute(name, this.createMappedName(pd, this.qualifyAttributes));
        } else if (this.isElement(pd)) {
            this.mapElement(name, this.createMappedName(pd, this.qualifyElements));
        }
    }

    protected PropertyDescriptor[] getPropertyDescriptors() {
        return this.descriptors;
    }

    protected PropertyDescriptor getPropertyDescriptor(String name) {
        for (int i = 0; i < this.descriptors.length; ++i) {
            if (!this.descriptors[i].getName().equals(name)) continue;
            return this.descriptors[i];
        }
        return null;
    }

    public AegisType getType(QName name) {
        QName typeName;
        AegisType type = this.mappedName2type.get(name);
        if (type == null && (typeName = this.getMappedTypeName(name)) != null && (type = this.getTypeMapping().getType(typeName)) != null) {
            this.mapType(name, type);
        }
        if (type == null) {
            PropertyDescriptor desc;
            try {
                desc = this.getPropertyDescriptorFromMappedName(name);
            }
            catch (Exception e) {
                if (e instanceof DatabindingException) {
                    throw (DatabindingException)e;
                }
                throw new DatabindingException("Couldn't get properties.", (Throwable)e);
            }
            if (desc == null) {
                return null;
            }
            try {
                TypeMapping tm = this.getTypeMapping();
                TypeCreator tc = tm.getTypeCreator();
                type = tc.createType(desc);
            }
            catch (DatabindingException e) {
                e.prepend("Couldn't create type for property " + desc.getName() + " on " + this.getTypeClass());
                throw e;
            }
            if (this.registerType(desc)) {
                this.getTypeMapping().register(type);
            }
            this.mapType(name, type);
        }
        if (type == null) {
            throw new DatabindingException("Couldn't find type for property " + name);
        }
        return type;
    }

    protected boolean registerType(PropertyDescriptor desc) {
        return true;
    }

    public void mapType(QName name, AegisType type) {
        this.mappedName2type.put(name, type);
    }

    private QName getMappedTypeName(QName name) {
        return this.mappedName2typeName.get(name);
    }

    public TypeMapping getTypeMapping() {
        return this.typeMapping;
    }

    public void setTypeMapping(TypeMapping typeMapping) {
        this.typeMapping = typeMapping;
    }

    protected QName createMappedName(PropertyDescriptor desc, boolean qualified) {
        if (qualified) {
            return new QName(this.getDefaultNamespace(), desc.getName());
        }
        return new QName(null, desc.getName());
    }

    public void mapAttribute(String property, QName mappedName) {
        this.mappedName2pdName.put(mappedName, property);
        this.attributes.add(mappedName);
    }

    public void mapElement(String property, QName mappedName) {
        this.mappedName2pdName.put(mappedName, property);
        this.elements.add(mappedName);
    }

    public void mapTypeName(QName mappedName, QName type) {
        this.mappedName2typeName.put(mappedName, type);
    }

    private void initializeProperties() {
        PropertyDescriptor[] propertyDescriptors;
        BeanInfo beanInfo = null;
        try {
            if (this.beanClass.isInterface() || this.beanClass.isPrimitive()) {
                this.descriptors = this.getInterfacePropertyDescriptors(this.beanClass);
            } else if (!this.beanClass.isEnum() && this.beanClass != Object.class && this.beanClass != Throwable.class && this.beanClass != Throwable.class) {
                beanInfo = Throwable.class.isAssignableFrom(this.beanClass) ? Introspector.getBeanInfo(this.beanClass, Throwable.class) : (RuntimeException.class.isAssignableFrom(this.beanClass) ? Introspector.getBeanInfo(this.beanClass, RuntimeException.class) : (Throwable.class.isAssignableFrom(this.beanClass) ? Introspector.getBeanInfo(this.beanClass, Throwable.class) : Introspector.getBeanInfo(this.beanClass, Object.class)));
            }
        }
        catch (IntrospectionException e) {
            throw new DatabindingException("Couldn't introspect interface.", (Throwable)e);
        }
        if (beanInfo != null && (propertyDescriptors = beanInfo.getPropertyDescriptors()) != null) {
            this.descriptors = ReflectionUtil.getPropertyDescriptorsAvoidSunBug(this.getClass(), beanInfo, this.beanClass, propertyDescriptors);
        }
        if (this.descriptors == null) {
            this.descriptors = new PropertyDescriptor[0];
        }
        Arrays.sort(this.descriptors, new Comparator<PropertyDescriptor>(){

            @Override
            public int compare(PropertyDescriptor o1, PropertyDescriptor o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
    }

    private PropertyDescriptor[] getInterfacePropertyDescriptors(Class<?> clazz) {
        ArrayList<PropertyDescriptor> pds = new ArrayList<PropertyDescriptor>();
        this.getInterfacePropertyDescriptors(clazz, pds, new HashSet());
        return pds.toArray(new PropertyDescriptor[pds.size()]);
    }

    private void getInterfacePropertyDescriptors(Class<?> clazz, List<PropertyDescriptor> pds, Set<Class<?>> classes) {
        if (classes.contains(clazz)) {
            return;
        }
        classes.add(clazz);
        try {
            Class<?>[] interfaces = clazz.getInterfaces();
            BeanInfo info = Introspector.getBeanInfo(clazz);
            for (int j = 0; j < info.getPropertyDescriptors().length; ++j) {
                PropertyDescriptor pd = info.getPropertyDescriptors()[j];
                if (this.containsPropertyName(pds, pd.getName())) continue;
                pds.add(pd);
            }
            for (int i = 0; i < interfaces.length; ++i) {
                this.getInterfacePropertyDescriptors(interfaces[i], pds, classes);
            }
        }
        catch (IntrospectionException e) {
            // empty catch block
        }
    }

    private boolean containsPropertyName(List<PropertyDescriptor> pds, String name) {
        for (PropertyDescriptor pd : pds) {
            if (!pd.getName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public PropertyDescriptor getPropertyDescriptorFromMappedName(QName name) {
        return this.getPropertyDescriptor(this.getPropertyNameFromMappedName(name));
    }

    protected boolean isAttribute(PropertyDescriptor desc) {
        return false;
    }

    protected boolean isElement(PropertyDescriptor desc) {
        return true;
    }

    protected boolean isSerializable(PropertyDescriptor desc) {
        return true;
    }

    protected Class<?> getTypeClass() {
        return this.beanClass;
    }

    public boolean isNillable(QName name) {
        AegisType type = this.getType(name);
        if (!type.isNillable()) {
            return false;
        }
        return this.nillable;
    }

    public int getMinOccurs(QName name) {
        return this.minOccurs;
    }

    public int getMaxOccurs(QName name) {
        return 1;
    }

    public long getMinOccurs() {
        return this.minOccurs;
    }

    public void setDefaultMinOccurs(int m) {
        this.minOccurs = m;
    }

    public void setDefaultNillable(boolean n) {
        this.nillable = n;
    }

    private String getPropertyNameFromMappedName(QName name) {
        return this.mappedName2pdName.get(name);
    }

    public List<QName> getAttributes() {
        return this.attributes;
    }

    public List<QName> getElements() {
        return this.elements;
    }

    public boolean isExtensibleElements() {
        return this.extensibleElements;
    }

    public void setExtensibleElements(boolean futureProof) {
        this.extensibleElements = futureProof;
    }

    public boolean isExtensibleAttributes() {
        return this.extensibleAttributes;
    }

    public void setExtensibleAttributes(boolean extensibleAttributes) {
        this.extensibleAttributes = extensibleAttributes;
    }

    public void setExtension(boolean extension) {
        this.isExtension = extension;
    }

    public boolean isExtension() {
        return this.isExtension;
    }

    public boolean isQualifyAttributes() {
        return this.qualifyAttributes;
    }

    public void setQualifyAttributes(boolean qualifyAttributes) {
        this.qualifyAttributes = qualifyAttributes;
    }

    public boolean isQualifyElements() {
        return this.qualifyElements;
    }

    public void setQualifyElements(boolean qualifyElements) {
        this.qualifyElements = qualifyElements;
    }
}

