/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.corba.processors.wsdl;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.wsdl.Definition;
import javax.wsdl.Input;
import javax.wsdl.Message;
import javax.wsdl.Operation;
import javax.wsdl.Output;
import javax.wsdl.Part;
import javax.xml.namespace.QName;
import org.apache.cxf.binding.corba.wsdl.ArgType;
import org.apache.cxf.binding.corba.wsdl.CorbaTypeImpl;
import org.apache.cxf.binding.corba.wsdl.ModeType;
import org.apache.cxf.binding.corba.wsdl.ParamType;
import org.apache.cxf.common.xmlschema.SchemaCollection;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.tools.corba.processors.wsdl.WSDLToCorbaBinding;
import org.apache.cxf.tools.corba.processors.wsdl.WSDLToCorbaHelper;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaAnnotation;
import org.apache.ws.commons.schema.XmlSchemaAnnotationItem;
import org.apache.ws.commons.schema.XmlSchemaAppInfo;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaExternal;
import org.apache.ws.commons.schema.XmlSchemaImport;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaSequenceMember;
import org.apache.ws.commons.schema.XmlSchemaType;

public final class WSDLParameter {
    static Definition definition;

    public void processParameters(WSDLToCorbaBinding wsdlToCorbaBinding, Operation operation, Definition def, SchemaCollection xmlSchemaList, List<ParamType> params, List<ArgType> returns, boolean simpleOrdering) throws Exception {
        definition = def;
        ArrayList<ParamType> inputs = new ArrayList<ParamType>();
        ArrayList<ParamType> outputs = new ArrayList<ParamType>();
        ArrayList<ArgType> returnOutputs = new ArrayList<ArgType>();
        boolean isWrapped = this.isWrappedOperation(operation, xmlSchemaList);
        if (isWrapped) {
            this.processWrappedInputParams(wsdlToCorbaBinding, operation, xmlSchemaList, inputs);
        } else {
            this.processInputParams(wsdlToCorbaBinding, operation, xmlSchemaList, inputs);
        }
        if (isWrapped) {
            this.processWrappedOutputParams(wsdlToCorbaBinding, operation, xmlSchemaList, inputs, outputs);
        } else {
            this.processOutputParams(wsdlToCorbaBinding, operation, xmlSchemaList, inputs, outputs);
        }
        this.processReturnParams(outputs, returnOutputs);
        this.orderParameters(inputs, outputs, true);
        returns.addAll(returnOutputs);
        params.addAll(inputs);
    }

    private void processWrappedInputParams(WSDLToCorbaBinding wsdlToCorbaBinding, Operation operation, SchemaCollection xmlSchemaList, List<ParamType> inputs) throws Exception {
        Input input = operation.getInput();
        if (input != null) {
            XmlSchemaSequence seq;
            Message msg = input.getMessage();
            Part part = (Part)msg.getOrderedParts(null).iterator().next();
            XmlSchemaComplexType schemaType = null;
            XmlSchemaElement el = WSDLParameter.getElement(part, xmlSchemaList);
            if (el != null && el.getSchemaType() != null) {
                schemaType = (XmlSchemaComplexType)el.getSchemaType();
            }
            if ((seq = (XmlSchemaSequence)schemaType.getParticle()) != null) {
                for (XmlSchemaSequenceMember seqItem : seq.getItems()) {
                    if (!(seqItem instanceof XmlSchemaElement)) continue;
                    el = (XmlSchemaElement)seqItem;
                    QName typeName = el.getSchemaTypeName();
                    if (typeName == null) {
                        typeName = el.getQName();
                    }
                    QName idltype = WSDLParameter.getIdlType(wsdlToCorbaBinding, el.getSchemaType(), typeName, el.isNillable());
                    ParamType paramtype = WSDLParameter.createParam(wsdlToCorbaBinding, "in", el.getQName().getLocalPart(), idltype);
                    if (paramtype == null) continue;
                    inputs.add(paramtype);
                }
            }
        }
    }

    private void processInputParams(WSDLToCorbaBinding wsdlToCorbaBinding, Operation operation, SchemaCollection xmlSchemaList, List<ParamType> inputs) throws Exception {
        Input input = operation.getInput();
        if (input != null) {
            Message msg = input.getMessage();
            List<Part> parts = CastUtils.cast(msg.getOrderedParts(null));
            for (Part part : parts) {
                XmlSchemaType schemaType = null;
                boolean isObjectRef = this.isObjectReference(xmlSchemaList, part.getElementName());
                if (part.getElementName() != null && !isObjectRef) {
                    QName typeName;
                    XmlSchemaElement el = WSDLParameter.getElement(part, xmlSchemaList);
                    if (el != null && el.getSchemaType() != null) {
                        schemaType = el.getSchemaType();
                    }
                    if ((typeName = el.getSchemaTypeName()) == null) {
                        typeName = el.getQName();
                    }
                    QName idltype = WSDLParameter.getIdlType(wsdlToCorbaBinding, schemaType, typeName, el.isNillable());
                    ParamType paramtype = WSDLParameter.createParam(wsdlToCorbaBinding, "in", part.getName(), idltype);
                    if (paramtype == null) continue;
                    inputs.add(paramtype);
                    continue;
                }
                if (part.getTypeName() == null) continue;
                schemaType = WSDLParameter.getType(part, xmlSchemaList);
                QName typeName = part.getTypeName();
                if (isObjectRef) {
                    typeName = part.getElementName();
                }
                QName idltype = WSDLParameter.getIdlType(wsdlToCorbaBinding, schemaType, typeName, false);
                ParamType paramtype = WSDLParameter.createParam(wsdlToCorbaBinding, "in", part.getName(), idltype);
                if (paramtype == null) continue;
                inputs.add(paramtype);
            }
        }
    }

    private void processWrappedOutputParams(WSDLToCorbaBinding wsdlToCorbaBinding, Operation operation, SchemaCollection xmlSchemaList, List<ParamType> inputs, List<ParamType> outputs) throws Exception {
        Output output = operation.getOutput();
        if (output != null) {
            XmlSchemaSequence seq;
            Message msg = output.getMessage();
            Part part = (Part)msg.getOrderedParts(null).iterator().next();
            XmlSchemaComplexType schemaType = null;
            XmlSchemaElement el = WSDLParameter.getElement(part, xmlSchemaList);
            if (el != null && el.getSchemaType() != null) {
                schemaType = (XmlSchemaComplexType)el.getSchemaType();
            }
            if ((seq = (XmlSchemaSequence)schemaType.getParticle()) != null) {
                for (XmlSchemaSequenceMember seqMember : seq.getItems()) {
                    if (!(seqMember instanceof XmlSchemaElement)) continue;
                    el = (XmlSchemaElement)seqMember;
                    this.processWrappedOutputParam(wsdlToCorbaBinding, el, inputs, outputs);
                }
            }
        }
    }

    private void processWrappedOutputParam(WSDLToCorbaBinding wsdlToCorbaBinding, XmlSchemaElement el, List<ParamType> inputs, List<ParamType> outputs) throws Exception {
        ParamType paramtype = null;
        for (int i = 0; i < inputs.size(); ++i) {
            if (!inputs.get(i).getName().equals(el.getQName().getLocalPart())) continue;
            inputs.remove(i);
            QName typeName = el.getSchemaTypeName();
            if (typeName == null) {
                typeName = el.getQName();
            }
            QName idltype = WSDLParameter.getIdlType(wsdlToCorbaBinding, el.getSchemaType(), typeName, el.isNillable());
            paramtype = WSDLParameter.createParam(wsdlToCorbaBinding, "inout", el.getQName().getLocalPart(), idltype);
            if (paramtype == null) continue;
            inputs.add(paramtype);
        }
        if (paramtype == null) {
            QName typeName = el.getSchemaTypeName();
            if (typeName == null) {
                typeName = el.getQName();
            }
            QName idltype = WSDLParameter.getIdlType(wsdlToCorbaBinding, el.getSchemaType(), typeName, el.isNillable());
            paramtype = WSDLParameter.createParam(wsdlToCorbaBinding, "out", el.getQName().getLocalPart(), idltype);
            if (paramtype != null) {
                outputs.add(paramtype);
            }
        }
    }

    private void processOutputParams(WSDLToCorbaBinding wsdlToCorbaBinding, Operation operation, SchemaCollection xmlSchemaList, List<ParamType> inputs, List<ParamType> outputs) throws Exception {
        Output output = operation.getOutput();
        if (output != null) {
            Message msg = output.getMessage();
            List<Part> parts = CastUtils.cast(msg.getOrderedParts(null));
            for (Part part : parts) {
                XmlSchemaType schemaType = null;
                String mode = "out";
                ParamType paramtype = null;
                boolean isObjectRef = this.isObjectReference(xmlSchemaList, part.getElementName());
                for (int x = 0; x < inputs.size(); ++x) {
                    paramtype = null;
                    ParamType d2 = inputs.get(x);
                    if (part.getElementName() != null && !isObjectRef) {
                        QName typeName;
                        XmlSchemaElement el = WSDLParameter.getElement(part, xmlSchemaList);
                        if (el != null && el.getSchemaType() != null) {
                            schemaType = el.getSchemaType();
                        }
                        if ((typeName = el.getSchemaTypeName()) == null) {
                            typeName = el.getQName();
                        }
                        QName idltype = WSDLParameter.getIdlType(wsdlToCorbaBinding, schemaType, typeName, el.isNillable());
                        if (!d2.getName().equals(part.getName()) || !d2.getIdltype().equals(idltype)) continue;
                        inputs.remove(x);
                        paramtype = WSDLParameter.createParam(wsdlToCorbaBinding, "inout", part.getName(), idltype);
                        inputs.add(paramtype);
                        continue;
                    }
                    schemaType = WSDLParameter.getType(part, xmlSchemaList);
                    QName typeName = part.getTypeName();
                    if (isObjectRef) {
                        typeName = part.getElementName();
                    }
                    QName idltype = WSDLParameter.getIdlType(wsdlToCorbaBinding, schemaType, typeName, false);
                    if (!d2.getName().equals(part.getName()) || !d2.getIdltype().equals(idltype)) continue;
                    inputs.remove(x);
                    paramtype = WSDLParameter.createParam(wsdlToCorbaBinding, "inout", part.getName(), idltype);
                    inputs.add(paramtype);
                }
                if (paramtype != null) continue;
                if (part.getElementName() != null && !isObjectRef) {
                    XmlSchemaElement el = WSDLParameter.getElement(part, xmlSchemaList);
                    QName typeName = el.getSchemaTypeName();
                    if (typeName == null) {
                        typeName = el.getQName();
                    }
                    QName idltype = WSDLParameter.getIdlType(wsdlToCorbaBinding, schemaType, typeName, el.isNillable());
                    paramtype = WSDLParameter.createParam(wsdlToCorbaBinding, mode, part.getName(), idltype);
                } else {
                    QName typeName = part.getTypeName();
                    if (isObjectRef) {
                        typeName = part.getElementName();
                    }
                    QName idltype = WSDLParameter.getIdlType(wsdlToCorbaBinding, schemaType, typeName, false);
                    paramtype = WSDLParameter.createParam(wsdlToCorbaBinding, mode, part.getName(), idltype);
                }
                if (paramtype == null) continue;
                outputs.add(paramtype);
            }
        }
    }

    private void processReturnParams(List<ParamType> outputs, List<ArgType> returns) {
        ParamType d2;
        if (outputs.size() > 0 && (d2 = outputs.get(0)).getMode().value().equals("out")) {
            ArgType argType = new ArgType();
            argType.setName(d2.getName());
            argType.setIdltype(d2.getIdltype());
            returns.add(argType);
            outputs.remove(0);
        }
    }

    private void orderParameters(List<ParamType> inputs, List<ParamType> outputs, boolean simpleOrdering) {
        ListIterator<ParamType> inputit = inputs.listIterator();
        while (inputit.hasNext()) {
            ParamType d2 = inputit.next();
            if (!d2.getMode().value().equals("inout")) continue;
            ListIterator<ParamType> it = outputs.listIterator();
            while (it.hasNext()) {
                ParamType d3 = it.next();
                if (d3.getName().equals(d2.getName()) || simpleOrdering || d3.getMode().value().equals("inout")) continue;
                it.remove();
                inputit.previous();
                inputit.add(d3);
                inputit.next();
            }
        }
        for (ParamType d3 : outputs) {
            inputs.add(d3);
        }
    }

    private static XmlSchemaType getType(Part part, SchemaCollection xmlSchemaList) throws Exception {
        XmlSchemaType schemaType = null;
        for (XmlSchema xmlSchema : xmlSchemaList.getXmlSchemas()) {
            if (part.getTypeName() == null || (schemaType = WSDLParameter.findSchemaType(xmlSchema, part.getTypeName())) == null) continue;
            return schemaType;
        }
        return schemaType;
    }

    private static XmlSchemaType findSchemaType(XmlSchema xmlSchema, QName typeName) {
        XmlSchemaType schemaType = xmlSchema.getTypeByName(typeName);
        if (schemaType == null) {
            for (XmlSchemaExternal ext : xmlSchema.getExternals()) {
                if (!(ext instanceof XmlSchemaImport)) continue;
                XmlSchemaImport xmlImport = (XmlSchemaImport)ext;
                if (xmlImport.getNamespace().equals(typeName.getNamespaceURI())) {
                    XmlSchema importSchema = xmlImport.getSchema();
                    schemaType = importSchema.getTypeByName(typeName);
                    continue;
                }
                schemaType = WSDLParameter.findSchemaType(ext.getSchema(), typeName);
                if (schemaType == null) continue;
                return schemaType;
            }
            if (schemaType != null) {
                return schemaType;
            }
        }
        return schemaType;
    }

    private static XmlSchemaElement getElement(Part part, SchemaCollection xmlSchemaList) throws Exception {
        XmlSchemaElement schemaElement = null;
        for (XmlSchema xmlSchema : xmlSchemaList.getXmlSchemas()) {
            if (part.getElementName() == null || (schemaElement = WSDLParameter.findElement(xmlSchema, part.getElementName())) == null) continue;
            return schemaElement;
        }
        return schemaElement;
    }

    private static XmlSchemaElement findElement(XmlSchema xmlSchema, QName elName) {
        XmlSchemaElement schemaElement = null;
        schemaElement = xmlSchema.getElementByName(elName);
        if (schemaElement == null) {
            String prefix = definition.getPrefix(elName.getNamespaceURI());
            QName name = new QName(elName.getNamespaceURI(), prefix + ":" + elName.getLocalPart(), prefix);
            schemaElement = xmlSchema.getElementByName(name);
        }
        if (schemaElement != null) {
            return schemaElement;
        }
        for (XmlSchemaExternal ext : xmlSchema.getExternals()) {
            if (ext instanceof XmlSchemaImport || (schemaElement = WSDLParameter.findElement(ext.getSchema(), elName)) == null) continue;
            return schemaElement;
        }
        return schemaElement;
    }

    private static QName getIdlType(WSDLToCorbaBinding wsdlToCorbaBinding, XmlSchemaType schemaType, QName typeName, boolean nill) throws Exception {
        QName idltype = null;
        CorbaTypeImpl corbaTypeImpl = null;
        if (schemaType == null) {
            corbaTypeImpl = (CorbaTypeImpl)WSDLToCorbaHelper.CORBAPRIMITIVEMAP.get(typeName);
            if (nill) {
                QName qname = corbaTypeImpl.getQName();
                idltype = wsdlToCorbaBinding.getHelper().createQNameCorbaNamespace(qname.getLocalPart() + "_nil");
            } else if (corbaTypeImpl == null) {
                XmlSchemaElement schemaObj = WSDLParameter.getSchemaObject(wsdlToCorbaBinding, typeName);
                XmlSchemaAnnotation annotation = null;
                if (schemaObj instanceof XmlSchemaElement) {
                    XmlSchemaElement el = schemaObj;
                    schemaType = el.getSchemaType();
                    annotation = schemaObj.getAnnotation();
                }
                idltype = WSDLParameter.getSchemaTypeName(wsdlToCorbaBinding, schemaType, annotation, typeName, nill);
            } else {
                idltype = corbaTypeImpl.getQName();
            }
        } else {
            XmlSchemaElement schemaObj = WSDLParameter.getSchemaObject(wsdlToCorbaBinding, typeName);
            XmlSchemaAnnotation annotation = null;
            if (schemaObj instanceof XmlSchemaElement) {
                annotation = schemaObj.getAnnotation();
            }
            idltype = WSDLParameter.getSchemaTypeName(wsdlToCorbaBinding, schemaType, annotation, typeName, nill);
        }
        return idltype;
    }

    private static XmlSchemaElement getSchemaObject(WSDLToCorbaBinding wsdlToCorbaBinding, QName typeName) {
        SchemaCollection schemaList = wsdlToCorbaBinding.getHelper().getXMLSchemaList();
        for (XmlSchema s : schemaList.getXmlSchemas()) {
            XmlSchemaElement e = s.getElementByName(typeName);
            if (e == null) continue;
            return e;
        }
        return null;
    }

    private static QName getSchemaTypeName(WSDLToCorbaBinding wsdlToCorbaBinding, XmlSchemaType schemaType, XmlSchemaAnnotation annotation, QName typeName, boolean nill) throws Exception {
        QName idltype = null;
        CorbaTypeImpl corbaTypeImpl = null;
        corbaTypeImpl = wsdlToCorbaBinding.getHelper().convertSchemaToCorbaType(schemaType, typeName, null, annotation, false);
        if (corbaTypeImpl == null) {
            throw new Exception("Couldn't convert schema type to corba type : " + typeName);
        }
        if (nill) {
            QName qname = corbaTypeImpl.getQName();
            idltype = wsdlToCorbaBinding.getHelper().createQNameCorbaNamespace(qname.getLocalPart() + "_nil");
        } else {
            idltype = corbaTypeImpl.getQName();
        }
        return idltype;
    }

    private static ParamType createParam(WSDLToCorbaBinding wsdlToCorbaBinding, String mode, String name, QName idltype) throws Exception {
        ParamType paramtype = new ParamType();
        ModeType modeType = ModeType.fromValue(mode);
        paramtype.setName(name);
        paramtype.setMode(modeType);
        paramtype.setIdltype(idltype);
        return paramtype;
    }

    private boolean isWrappedOperation(Operation op, SchemaCollection xmlSchemaList) throws Exception {
        Message inputMessage = op.getInput().getMessage();
        Message outputMessage = null;
        if (op.getOutput() != null) {
            outputMessage = op.getOutput().getMessage();
        }
        boolean passedRule = true;
        if (inputMessage == null || inputMessage.getParts().size() != 1 || outputMessage != null && outputMessage.getParts().size() > 1) {
            passedRule = false;
        }
        if (!passedRule) {
            return false;
        }
        XmlSchemaElement inputEl = null;
        XmlSchemaElement outputEl = null;
        Part inputPart = (Part)inputMessage.getParts().values().iterator().next();
        if (inputPart.getElementName() == null) {
            passedRule = false;
        } else {
            QName inputElementName = inputPart.getElementName();
            inputEl = WSDLParameter.getElement(inputPart, xmlSchemaList);
            if (inputEl == null || !op.getName().equals(inputElementName.getLocalPart())) {
                passedRule = false;
            }
        }
        if (!passedRule) {
            return false;
        }
        Part outputPart = null;
        if (outputMessage != null && outputMessage.getParts().size() == 1 && (outputPart = (Part)outputMessage.getParts().values().iterator().next()) != null) {
            if (outputPart.getElementName() == null || WSDLParameter.getElement(outputPart, xmlSchemaList) == null) {
                passedRule = false;
            } else {
                outputEl = WSDLParameter.getElement(outputPart, xmlSchemaList);
            }
        }
        if (!passedRule) {
            return false;
        }
        XmlSchemaComplexType xsct = null;
        if (inputEl.getSchemaType() instanceof XmlSchemaComplexType) {
            xsct = (XmlSchemaComplexType)inputEl.getSchemaType();
            if (this.hasAttributes(xsct) || !this.isWrappableSequence(xsct)) {
                passedRule = false;
            }
        } else {
            passedRule = false;
        }
        if (!passedRule) {
            return false;
        }
        if (outputMessage != null) {
            if (outputEl != null && outputEl.getSchemaType() instanceof XmlSchemaComplexType) {
                xsct = (XmlSchemaComplexType)outputEl.getSchemaType();
                if (this.hasAttributes(xsct) || !this.isWrappableSequence(xsct)) {
                    passedRule = false;
                }
            } else {
                passedRule = false;
            }
        }
        return passedRule;
    }

    private boolean hasAttributes(XmlSchemaComplexType complexType) {
        return complexType.getAnyAttribute() != null || complexType.getAttributes().size() > 0;
    }

    private boolean isWrappableSequence(XmlSchemaComplexType type) {
        if (type.getParticle() instanceof XmlSchemaSequence) {
            XmlSchemaSequence seq = (XmlSchemaSequence)type.getParticle();
            List items = seq.getItems();
            for (XmlSchemaSequenceMember member : items) {
                if (member instanceof XmlSchemaElement) continue;
                return false;
            }
            return true;
        }
        return type.getParticle() == null;
    }

    private boolean isObjectReference(SchemaCollection schemaList, QName name) {
        for (XmlSchema schema : schemaList.getXmlSchemas()) {
            XmlSchemaAnnotation annotation;
            XmlSchemaElement element = schema.getElementByName(name);
            if (element == null || (annotation = element.getAnnotation()) == null) continue;
            List annotationColl = annotation.getItems();
            for (XmlSchemaAnnotationItem item : annotationColl) {
                if (!(item instanceof XmlSchemaAppInfo)) continue;
                return true;
            }
        }
        return false;
    }
}

