/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.saml;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Message;
import org.apache.cxf.rs.security.saml.AbstractSamlOutInterceptor;
import org.apache.ws.security.saml.ext.AssertionWrapper;

public class SamlHeaderOutInterceptor
extends AbstractSamlOutInterceptor {
    private static final Logger LOG = LogUtils.getL7dLogger(SamlHeaderOutInterceptor.class);

    @Override
    public void handleMessage(Message message) throws Fault {
        AssertionWrapper assertionWrapper = this.createAssertion(message);
        try {
            String encodedToken = this.encodeToken(assertionWrapper.assertionToString());
            Map<String, List<String>> headers = this.getHeaders(message);
            StringBuilder builder = new StringBuilder();
            builder.append("SAML").append(" ").append(encodedToken);
            headers.put("Authorization", CastUtils.cast(Collections.singletonList(builder.toString()), String.class));
        }
        catch (Exception ex) {
            StringWriter sw = new StringWriter();
            ex.printStackTrace(new PrintWriter(sw));
            LOG.warning(sw.toString());
            throw new Fault(new RuntimeException(ex.getMessage() + ", stacktrace: " + sw.toString()));
        }
    }

    private Map<String, List<String>> getHeaders(Message message) {
        Map<String, List<String>> headers = CastUtils.cast((Map)message.get(Message.PROTOCOL_HEADERS));
        if (headers == null) {
            headers = new HashMap<String, List<String>>();
        }
        return headers;
    }
}

