/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.services;

import java.util.logging.Logger;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.OAuthError;
import org.apache.cxf.rs.security.oauth2.provider.OAuthDataProvider;
import org.apache.cxf.rs.security.oauth2.provider.OAuthServiceException;

public abstract class AbstractOAuthService {
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractOAuthService.class);
    private MessageContext mc;
    private OAuthDataProvider dataProvider;
    private boolean blockUnsecureRequests;

    @Context
    public void setMessageContext(MessageContext context) {
        this.mc = context;
    }

    public MessageContext getMessageContext() {
        return this.mc;
    }

    public void setDataProvider(OAuthDataProvider dataProvider) {
        this.dataProvider = dataProvider;
    }

    public OAuthDataProvider getDataProvider() {
        return this.dataProvider;
    }

    protected MultivaluedMap<String, String> getQueryParameters() {
        return this.getMessageContext().getUriInfo().getQueryParameters();
    }

    protected Client getClient(MultivaluedMap<String, String> params) {
        return this.getClient((String)params.getFirst((Object)"client_id"));
    }

    protected Client getClient(String clientId) {
        Client client = null;
        if (clientId != null) {
            try {
                client = this.dataProvider.getClient(clientId);
            }
            catch (OAuthServiceException oAuthServiceException) {
                // empty catch block
            }
        }
        if (client == null) {
            this.reportInvalidRequestError("Client ID is invalid");
        }
        return client;
    }

    protected void checkTransportSecurity() {
        if (!this.mc.getSecurityContext().isSecure()) {
            LOG.warning("Unsecure HTTP, Transport Layer Security is recommended");
            if (this.blockUnsecureRequests) {
                throw new WebApplicationException(400);
            }
        }
    }

    protected void reportInvalidRequestError(String errorDescription) {
        OAuthError error = new OAuthError("invalid_request", errorDescription);
        throw new WebApplicationException(Response.status((int)400).type("application/json").entity((Object)error).build());
    }

    public void setBlockUnsecureRequests(boolean blockUnsecureRequests) {
        this.blockUnsecureRequests = blockUnsecureRequests;
    }
}

