/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.apache.cxf.aegis.AegisContext;
import org.apache.cxf.aegis.type.TypeMapping;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.message.Attachment;

public class Context {
    private AegisContext globalContext;
    private Collection<Attachment> attachments;
    private Fault fault;
    private Map<Class<?>, Object> properties;
    private Map<String, Object> namedProperties;

    public Context(AegisContext aegisContext) {
        this.globalContext = aegisContext;
        this.properties = new HashMap();
    }

    public TypeMapping getTypeMapping() {
        return this.globalContext.getTypeMapping();
    }

    public Collection<Attachment> getAttachments() {
        return this.attachments;
    }

    public void setAttachments(Collection<Attachment> attachments) {
        this.attachments = attachments;
    }

    public boolean isWriteXsiTypes() {
        return this.globalContext.isWriteXsiTypes();
    }

    public boolean isReadXsiTypes() {
        return this.globalContext.isReadXsiTypes();
    }

    public void setFault(Fault fault) {
        this.fault = fault;
    }

    public Fault getFault() {
        return this.fault;
    }

    public AegisContext getGlobalContext() {
        return this.globalContext;
    }

    public boolean isMtomEnabled() {
        return this.globalContext.isMtomEnabled();
    }

    public <T> T getProperty(Class<T> key) {
        return key.cast(this.properties.get(key));
    }

    public void setProperty(Object value) {
        this.properties.put(value.getClass(), value);
    }

    public void setProperty(String name, Object value) {
        this.namedProperties.put(name, value);
    }

    public <T> T getProperty(String name, Class<T> type) {
        return type.cast(this.namedProperties.get(name));
    }
}

