/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.saml.sso.filter;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.joda.time.DateTime;
import org.opensaml.Configuration;
import org.opensaml.common.SAMLObjectBuilder;
import org.opensaml.common.SAMLVersion;
import org.opensaml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml2.core.AuthnContextComparisonTypeEnumeration;
import org.opensaml.saml2.core.AuthnContextDeclRef;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.NameIDPolicy;
import org.opensaml.saml2.core.RequestedAuthnContext;
import org.opensaml.xml.XMLObjectBuilderFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SamlpRequestComponentBuilder {
    private static SAMLObjectBuilder<AuthnRequest> authnRequestBuilder;
    private static SAMLObjectBuilder<Issuer> issuerBuilder;
    private static SAMLObjectBuilder<NameIDPolicy> nameIDBuilder;
    private static SAMLObjectBuilder<RequestedAuthnContext> requestedAuthnCtxBuilder;
    private static SAMLObjectBuilder<AuthnContextClassRef> requestedAuthnCtxClassRefBuilder;
    private static XMLObjectBuilderFactory builderFactory;

    private SamlpRequestComponentBuilder() {
    }

    public static AuthnRequest createAuthnRequest(String serviceURL, boolean forceAuthn, boolean isPassive, String protocolBinding, SAMLVersion version, Issuer issuer, NameIDPolicy nameIDPolicy, RequestedAuthnContext requestedAuthnCtx) {
        if (authnRequestBuilder == null) {
            authnRequestBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(AuthnRequest.DEFAULT_ELEMENT_NAME);
        }
        AuthnRequest authnRequest = (AuthnRequest)authnRequestBuilder.buildObject();
        authnRequest.setAssertionConsumerServiceURL(serviceURL);
        authnRequest.setForceAuthn(Boolean.valueOf(forceAuthn));
        authnRequest.setID(UUID.randomUUID().toString());
        authnRequest.setIsPassive(Boolean.valueOf(isPassive));
        authnRequest.setIssueInstant(new DateTime());
        authnRequest.setProtocolBinding(protocolBinding);
        authnRequest.setVersion(version);
        authnRequest.setIssuer(issuer);
        authnRequest.setNameIDPolicy(nameIDPolicy);
        authnRequest.setRequestedAuthnContext(requestedAuthnCtx);
        return authnRequest;
    }

    public static Issuer createIssuer(String issuerValue) {
        if (issuerBuilder == null) {
            issuerBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(Issuer.DEFAULT_ELEMENT_NAME);
        }
        Issuer issuer = (Issuer)issuerBuilder.buildObject();
        issuer.setValue(issuerValue);
        return issuer;
    }

    public static NameIDPolicy createNameIDPolicy(boolean allowCreate, String format, String spNameQualifier) {
        if (nameIDBuilder == null) {
            nameIDBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(NameIDPolicy.DEFAULT_ELEMENT_NAME);
        }
        NameIDPolicy nameId = (NameIDPolicy)nameIDBuilder.buildObject();
        nameId.setAllowCreate(Boolean.valueOf(allowCreate));
        nameId.setFormat(format);
        nameId.setSPNameQualifier(spNameQualifier);
        return nameId;
    }

    public static RequestedAuthnContext createRequestedAuthnCtxPolicy(AuthnContextComparisonTypeEnumeration comparison, List<AuthnContextClassRef> authnCtxClassRefList, List<AuthnContextDeclRef> authnCtxDeclRefList) {
        if (requestedAuthnCtxBuilder == null) {
            requestedAuthnCtxBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(RequestedAuthnContext.DEFAULT_ELEMENT_NAME);
        }
        RequestedAuthnContext authnCtx = (RequestedAuthnContext)requestedAuthnCtxBuilder.buildObject();
        authnCtx.setComparison(comparison);
        if (authnCtxClassRefList != null) {
            ArrayList<AuthnContextClassRef> classRefList = authnCtx.getAuthnContextClassRefs();
            if (classRefList == null) {
                classRefList = new ArrayList<AuthnContextClassRef>();
            }
            classRefList.addAll(authnCtxClassRefList);
        }
        if (authnCtxDeclRefList != null) {
            ArrayList<AuthnContextDeclRef> declRefList = authnCtx.getAuthnContextDeclRefs();
            if (declRefList == null) {
                declRefList = new ArrayList<AuthnContextDeclRef>();
            }
            declRefList.addAll(authnCtxDeclRefList);
        }
        return authnCtx;
    }

    public static AuthnContextClassRef createAuthnCtxClassRef(String authnCtxClassRefValue) {
        if (requestedAuthnCtxClassRefBuilder == null) {
            requestedAuthnCtxClassRefBuilder = (SAMLObjectBuilder)builderFactory.getBuilder(AuthnContextClassRef.DEFAULT_ELEMENT_NAME);
        }
        AuthnContextClassRef authnCtxClassRef = (AuthnContextClassRef)requestedAuthnCtxClassRefBuilder.buildObject();
        authnCtxClassRef.setAuthnContextClassRef(authnCtxClassRefValue);
        return authnCtxClassRef;
    }

    static {
        builderFactory = Configuration.getBuilderFactory();
    }
}

