/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.configuration.jsse;

import java.io.IOException;
import java.security.GeneralSecurityException;
import org.apache.cxf.common.injection.NoJSR250Annotations;
import org.apache.cxf.configuration.jsse.TLSParameterJaxBUtils;
import org.apache.cxf.configuration.jsse.TLSServerParameters;
import org.apache.cxf.configuration.security.TLSServerParametersType;

@NoJSR250Annotations
public class TLSServerParametersConfig
extends TLSServerParameters {
    public TLSServerParametersConfig(TLSServerParametersType params) throws GeneralSecurityException, IOException {
        if (params.isSetSecureSocketProtocol()) {
            this.setSecureSocketProtocol(params.getSecureSocketProtocol());
        }
        if (params.isSetCipherSuitesFilter()) {
            this.setCipherSuitesFilter(params.getCipherSuitesFilter());
        }
        if (params.isSetCipherSuites()) {
            this.setCipherSuites(params.getCipherSuites().getCipherSuite());
        }
        if (params.isSetJsseProvider()) {
            this.setJsseProvider(params.getJsseProvider());
        }
        if (params.isSetSecureRandomParameters()) {
            this.setSecureRandom(TLSParameterJaxBUtils.getSecureRandom(params.getSecureRandomParameters()));
        }
        if (params.isSetClientAuthentication()) {
            this.setClientAuthentication(params.getClientAuthentication());
        }
        if (params.isSetKeyManagers()) {
            this.setKeyManagers(TLSParameterJaxBUtils.getKeyManagers(params.getKeyManagers()));
        }
        if (params.isSetTrustManagers()) {
            this.setTrustManagers(TLSParameterJaxBUtils.getTrustManagers(params.getTrustManagers()));
        }
        if (params.isSetCertConstraints()) {
            this.setCertConstraints(params.getCertConstraints());
        }
        if (params.isSetCertAlias()) {
            this.setCertAlias(params.getCertAlias());
        }
    }
}

