/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageImpl;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.ws.addressing.AddressingPropertiesImpl;
import org.apache.cxf.ws.rm.AbstractEndpoint;
import org.apache.cxf.ws.rm.DestinationSequence;
import org.apache.cxf.ws.rm.RMConstants;
import org.apache.cxf.ws.rm.RMContextUtils;
import org.apache.cxf.ws.rm.RMEndpoint;
import org.apache.cxf.ws.rm.RMException;
import org.apache.cxf.ws.rm.RMProperties;
import org.apache.cxf.ws.rm.SequenceFault;
import org.apache.cxf.ws.rm.SequenceFaultFactory;
import org.apache.cxf.ws.rm.persistence.RMMessage;
import org.apache.cxf.ws.rm.persistence.RMStore;
import org.apache.cxf.ws.rm.v200702.AckRequestedType;
import org.apache.cxf.ws.rm.v200702.Identifier;
import org.apache.cxf.ws.rm.v200702.SequenceType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Destination
extends AbstractEndpoint {
    private static final Logger LOG = LogUtils.getL7dLogger(Destination.class);
    private Map<String, DestinationSequence> map = new HashMap<String, DestinationSequence>();

    Destination(RMEndpoint reliableEndpoint) {
        super(reliableEndpoint);
    }

    public DestinationSequence getSequence(Identifier id) {
        return this.map.get(id.getValue());
    }

    public Collection<DestinationSequence> getAllSequences() {
        return CastUtils.cast(this.map.values());
    }

    public void addSequence(DestinationSequence seq) {
        this.addSequence(seq, true);
    }

    public void addSequence(DestinationSequence seq, boolean persist) {
        if (seq.getProtocol() == this.getReliableEndpoint().getProtocol()) {
            RMStore store;
            seq.setDestination(this);
            this.map.put(seq.getIdentifier().getValue(), seq);
            if (persist && null != (store = this.getReliableEndpoint().getManager().getStore())) {
                store.createDestinationSequence(seq);
            }
        } else {
            LOG.log(Level.SEVERE, "Incompatible protocol version");
        }
    }

    public void removeSequence(DestinationSequence seq) {
        this.map.remove(seq.getIdentifier().getValue());
        RMStore store = this.getReliableEndpoint().getManager().getStore();
        if (null != store) {
            store.removeDestinationSequence(seq.getIdentifier());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void acknowledge(Message message) throws SequenceFault, RMException {
        RMStore store;
        RMProperties rmps = RMContextUtils.retrieveRMProperties(message, false);
        SequenceType sequenceType = rmps.getSequence();
        if (null == sequenceType) {
            return;
        }
        DestinationSequence seq = this.getSequence(sequenceType.getIdentifier());
        if (null == seq) {
            RMConstants consts = this.getReliableEndpoint().getProtocol().getConstants();
            SequenceFaultFactory sff = new SequenceFaultFactory(consts);
            throw sff.createUnknownSequenceFault(sequenceType.getIdentifier());
        }
        if (seq.applyDeliveryAssurance(sequenceType.getMessageNumber(), message)) {
            if (MessageUtils.isTrue(message.get("org.apache.cxf.oneway.robust.delivering"))) {
                return;
            }
            seq.acknowledge(message);
            if (null != rmps.getCloseSequence()) {
                seq.setLastMessageNumber(sequenceType.getMessageNumber());
                this.ackImmediately(seq, message);
            }
        } else {
            try {
                message.getInterceptorChain().abort();
                Conduit conduit = message.getExchange().getDestination().getBackChannel(message, null, null);
                if (conduit != null) {
                    Message partial = Destination.createMessage(message.getExchange());
                    partial.remove("Content-Type");
                    partial.setExchange(message.getExchange());
                    conduit.prepare(partial);
                    conduit.close(partial);
                }
            }
            catch (IOException e) {
                LOG.log(Level.SEVERE, e.getMessage());
                throw new RMException(e);
            }
        }
        if (null != (store = this.getReliableEndpoint().getManager().getStore())) {
            RMMessage msg = null;
            if (!MessageUtils.isTrue(message.getContextualProperty("org.apache.cxf.oneway.robust"))) {
                msg = new RMMessage();
                msg.setContent((CachedOutputStream)message.get("org.apache.cxf.ws.rm.content"));
                msg.setMessageNumber(sequenceType.getMessageNumber());
            }
            store.persistIncoming(seq, msg);
        }
    }

    void ackRequested(Message message) throws SequenceFault, RMException {
        Collection<AckRequestedType> ars = RMContextUtils.retrieveRMProperties(message, false).getAcksRequested();
        if (null == ars) {
            return;
        }
        for (AckRequestedType ar : ars) {
            Identifier id = ar.getIdentifier();
            DestinationSequence seq = this.getSequence(id);
            if (null == seq) continue;
            this.ackImmediately(seq, message);
        }
    }

    void ackImmediately(DestinationSequence seq, Message message) throws RMException {
        seq.scheduleImmediateAcknowledgement();
        AddressingPropertiesImpl maps = RMContextUtils.retrieveMAPs(message, false, false);
        String replyToAddress = null;
        if (null != maps.getReplyTo()) {
            replyToAddress = maps.getReplyTo().getAddress().getValue();
        }
        if (!seq.getAcksTo().getAddress().getValue().equals(replyToAddress) && !seq.canPiggybackAckOnPartialResponse()) {
            this.getReliableEndpoint().getProxy().acknowledge(seq);
        }
    }

    void processingComplete(Message message) {
        SequenceType sequenceType = RMContextUtils.retrieveRMProperties(message, false).getSequence();
        if (null == sequenceType) {
            return;
        }
        DestinationSequence seq = this.getSequence(sequenceType.getIdentifier());
        if (null != seq) {
            long mn = sequenceType.getMessageNumber();
            seq.processingComplete(mn);
            seq.purgeAcknowledged(mn);
        }
    }

    void releaseDeliveringStatus(Message message) {
        DestinationSequence seq;
        RMProperties rmps = RMContextUtils.retrieveRMProperties(message, false);
        SequenceType sequenceType = rmps.getSequence();
        if (null != sequenceType && null != (seq = this.getSequence(sequenceType.getIdentifier()))) {
            seq.removeDeliveringMessageNumber(sequenceType.getMessageNumber());
        }
    }

    private static Message createMessage(Exchange exchange) {
        Endpoint ep = exchange.get(Endpoint.class);
        Message msg = null;
        if (ep != null) {
            msg = new MessageImpl();
            msg.setExchange(exchange);
            msg = ep.getBinding().createMessage(msg);
        }
        return msg;
    }
}

