/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j.policyvalidators;

import org.apache.cxf.message.Message;
import org.apache.cxf.message.MessageUtils;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.Token;

public abstract class AbstractTokenPolicyValidator {
    protected boolean isTokenRequired(Token token, Message message) {
        SPConstants.IncludeTokenType inclusion = token.getInclusion();
        if (inclusion == SPConstants.IncludeTokenType.INCLUDE_TOKEN_NEVER) {
            return false;
        }
        if (inclusion == SPConstants.IncludeTokenType.INCLUDE_TOKEN_ALWAYS) {
            return true;
        }
        boolean initiator = MessageUtils.isRequestor(message);
        if (initiator && inclusion == SPConstants.IncludeTokenType.INCLUDE_TOKEN_ALWAYS_TO_INITIATOR) {
            return true;
        }
        return !initiator && (inclusion == SPConstants.IncludeTokenType.INCLUDE_TOKEN_ONCE || inclusion == SPConstants.IncludeTokenType.INCLUDE_TOKEN_ALWAYS_TO_RECIPIENT);
    }
}

