/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.trust;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.URL;
import java.security.Key;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.dom.DOMSource;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.binding.soap.model.SoapOperationInfo;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.ModCountCopyOnWriteArrayList;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.configuration.Configurable;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.databinding.source.SourceDataBinding;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.endpoint.ClientImpl;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.EndpointException;
import org.apache.cxf.endpoint.EndpointImpl;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.message.Message;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.service.Service;
import org.apache.cxf.service.model.BindingInfo;
import org.apache.cxf.service.model.BindingOperationInfo;
import org.apache.cxf.service.model.EndpointInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.staxutils.StaxUtils;
import org.apache.cxf.staxutils.W3CDOMStreamWriter;
import org.apache.cxf.transport.Conduit;
import org.apache.cxf.ws.policy.EffectivePolicy;
import org.apache.cxf.ws.policy.PolicyBuilder;
import org.apache.cxf.ws.policy.PolicyEngine;
import org.apache.cxf.ws.policy.builder.primitive.PrimitiveAssertion;
import org.apache.cxf.ws.security.policy.model.AlgorithmSuite;
import org.apache.cxf.ws.security.policy.model.Binding;
import org.apache.cxf.ws.security.policy.model.Header;
import org.apache.cxf.ws.security.policy.model.ProtectionToken;
import org.apache.cxf.ws.security.policy.model.SecureConversationToken;
import org.apache.cxf.ws.security.policy.model.SignedEncryptedParts;
import org.apache.cxf.ws.security.policy.model.SymmetricBinding;
import org.apache.cxf.ws.security.policy.model.Trust10;
import org.apache.cxf.ws.security.policy.model.Trust13;
import org.apache.cxf.ws.security.tokenstore.SecurityToken;
import org.apache.cxf.ws.security.trust.STSUtils;
import org.apache.cxf.ws.security.trust.TrustException;
import org.apache.cxf.ws.security.trust.delegation.DelegationCallback;
import org.apache.cxf.wsdl11.WSDLServiceFactory;
import org.apache.neethi.All;
import org.apache.neethi.Assertion;
import org.apache.neethi.ExactlyOne;
import org.apache.neethi.Policy;
import org.apache.neethi.PolicyComponent;
import org.apache.ws.security.WSDocInfo;
import org.apache.ws.security.WSSConfig;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.components.crypto.Crypto;
import org.apache.ws.security.components.crypto.CryptoFactory;
import org.apache.ws.security.components.crypto.CryptoType;
import org.apache.ws.security.conversation.ConversationException;
import org.apache.ws.security.conversation.dkalgo.P_SHA1;
import org.apache.ws.security.handler.RequestData;
import org.apache.ws.security.message.token.Reference;
import org.apache.ws.security.processor.EncryptedKeyProcessor;
import org.apache.ws.security.util.Base64;
import org.apache.ws.security.util.WSSecurityUtil;
import org.apache.ws.security.util.XmlSchemaDateFormat;
import org.apache.xml.security.keys.content.X509Data;
import org.apache.xml.security.keys.content.keyvalues.DSAKeyValue;
import org.apache.xml.security.keys.content.keyvalues.RSAKeyValue;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class STSClient
implements Configurable,
InterceptorProvider {
    private static final Logger LOG = LogUtils.getL7dLogger(STSClient.class);
    Bus bus;
    String name = "default.sts-client";
    Client client;
    String location;
    String wsdlLocation;
    QName serviceName;
    QName endpointName;
    Policy policy;
    String soapVersion = "http://schemas.xmlsoap.org/soap/";
    int keySize = 256;
    boolean requiresEntropy = true;
    Element template;
    AlgorithmSuite algorithmSuite;
    String namespace = "http://docs.oasis-open.org/ws-sx/ws-trust/200512";
    String addressingNamespace;
    Object onBehalfOf;
    boolean enableAppliesTo = true;
    boolean useCertificateForConfirmationKeyInfo;
    boolean isSecureConv;
    boolean enableLifetime;
    int ttl = 300;
    Object actAs;
    String tokenType;
    String keyType;
    boolean sendKeyType = true;
    Message message;
    String context;
    Map<String, Object> ctx = new HashMap<String, Object>();
    List<Interceptor<? extends Message>> in = new ModCountCopyOnWriteArrayList<Interceptor<? extends Message>>();
    List<Interceptor<? extends Message>> out = new ModCountCopyOnWriteArrayList<Interceptor<? extends Message>>();
    List<Interceptor<? extends Message>> outFault = new ModCountCopyOnWriteArrayList<Interceptor<? extends Message>>();
    List<Interceptor<? extends Message>> inFault = new ModCountCopyOnWriteArrayList<Interceptor<? extends Message>>();
    List<AbstractFeature> features;

    public STSClient(Bus b) {
        this.bus = b;
    }

    @Override
    public String getBeanName() {
        return this.name;
    }

    public void setBeanName(String s) {
        this.name = s;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setMessage(Message message) {
        this.message = message;
    }

    public void setTtl(int ttl) {
        this.ttl = ttl;
    }

    public void setEnableLifetime(boolean enableLifetime) {
        this.enableLifetime = enableLifetime;
    }

    public void setPolicy(Object newPolicy) {
        if (newPolicy instanceof Policy) {
            this.setPolicyInternal((Policy)newPolicy);
        } else if (newPolicy instanceof Element) {
            this.setPolicyInternal((Element)newPolicy);
        } else {
            throw new IllegalArgumentException("Unsupported policy object.  Type must be org.apache.neethi.Policy or org.w3c.dom.Element.");
        }
    }

    public void setSoap12() {
        this.soapVersion = "http://schemas.xmlsoap.org/wsdl/soap12/";
    }

    public void setSoap11() {
        this.soapVersion = "http://schemas.xmlsoap.org/soap/";
    }

    public void setSoap11(boolean b) {
        if (b) {
            this.setSoap11();
        } else {
            this.setSoap12();
        }
    }

    public void setAddressingNamespace(String ad) {
        this.addressingNamespace = ad;
    }

    public void setTrust(Trust10 trust) {
        if (trust != null) {
            this.namespace = "http://schemas.xmlsoap.org/ws/2005/02/trust";
            this.requiresEntropy = trust.isRequireClientEntropy();
        }
    }

    public void setTrust(Trust13 trust) {
        if (trust != null) {
            this.namespace = "http://docs.oasis-open.org/ws-sx/ws-trust/200512";
            this.requiresEntropy = trust.isRequireClientEntropy();
        }
    }

    public boolean isRequiresEntropy() {
        return this.requiresEntropy;
    }

    public void setRequiresEntropy(boolean requiresEntropy) {
        this.requiresEntropy = requiresEntropy;
    }

    public boolean isSecureConv() {
        return this.isSecureConv;
    }

    public void setSecureConv(boolean secureConv) {
        this.isSecureConv = secureConv;
    }

    public boolean isEnableAppliesTo() {
        return this.enableAppliesTo;
    }

    public void setEnableAppliesTo(boolean enableAppliesTo) {
        this.enableAppliesTo = enableAppliesTo;
    }

    public String getContext() {
        return this.context;
    }

    public void setContext(String context) {
        this.context = context;
    }

    public void setAlgorithmSuite(AlgorithmSuite ag) {
        this.algorithmSuite = ag;
    }

    public Map<String, Object> getRequestContext() {
        return this.ctx;
    }

    public void setProperties(Map<String, Object> p) {
        this.ctx.putAll(p);
    }

    public Map<String, Object> getProperties() {
        return this.ctx;
    }

    public void setWsdlLocation(String wsdl) {
        this.wsdlLocation = wsdl;
    }

    public String getWsdlLocation() {
        return this.wsdlLocation;
    }

    public void setServiceName(String qn) {
        this.serviceName = QName.valueOf(qn);
    }

    public void setEndpointName(String qn) {
        this.endpointName = QName.valueOf(qn);
    }

    public void setServiceQName(QName qn) {
        this.serviceName = qn;
    }

    public QName getServiceQName() {
        return this.serviceName;
    }

    public void setEndpointQName(QName qn) {
        this.endpointName = qn;
    }

    public QName getEndpointQName() {
        return this.endpointName;
    }

    public void setActAs(Object actAs) {
        this.actAs = actAs;
    }

    public void setKeySize(int i) {
        this.keySize = i;
    }

    public int getKeySize() {
        return this.keySize;
    }

    public void setTokenType(String tokenType) {
        this.tokenType = tokenType;
    }

    public void setSendKeyType(boolean sendKeyType) {
        this.sendKeyType = sendKeyType;
    }

    public void setKeyType(String keyType) {
        this.keyType = keyType;
    }

    @Deprecated
    public void setOnBehalfOfElement(Element onBehalfOfElement) {
        this.onBehalfOf = onBehalfOfElement;
    }

    public void setOnBehalfOf(Object onBehalfOf) {
        this.onBehalfOf = onBehalfOf;
    }

    public void setUseCertificateForConfirmationKeyInfo(boolean useCertificate) {
        this.useCertificateForConfirmationKeyInfo = useCertificate;
    }

    public boolean isUseCertificateForConfirmationKeyInfo() {
        return this.useCertificateForConfirmationKeyInfo;
    }

    protected void setPolicyInternal(Policy newPolicy) {
        this.policy = newPolicy;
        if (this.algorithmSuite == null) {
            Iterator i = this.policy.getAlternatives();
            while (i.hasNext() && this.algorithmSuite == null) {
                List<PolicyComponent> p = CastUtils.cast((List)i.next());
                for (PolicyComponent p2 : p) {
                    if (!(p2 instanceof Binding)) continue;
                    this.algorithmSuite = ((Binding)p2).getAlgorithmSuite();
                }
            }
        }
    }

    protected void setPolicyInternal(Element newPolicy) {
        this.setPolicyInternal(this.bus.getExtension(PolicyBuilder.class).getPolicy(newPolicy));
    }

    public Client getClient() throws BusException, EndpointException {
        if (this.client == null) {
            this.createClient();
        }
        return this.client;
    }

    private void createClient() throws BusException, EndpointException {
        if (this.client != null) {
            return;
        }
        this.bus.getExtension(Configurer.class).configureBean(this.name, this);
        if (this.wsdlLocation != null) {
            WSDLServiceFactory factory = new WSDLServiceFactory(this.bus, this.wsdlLocation, this.serviceName);
            SourceDataBinding dataBinding = new SourceDataBinding();
            factory.setDataBinding(dataBinding);
            Service service = factory.create();
            service.setDataBinding(dataBinding);
            EndpointInfo ei = service.getEndpointInfo(this.endpointName);
            EndpointImpl endpoint = new EndpointImpl(this.bus, service, ei);
            this.client = new ClientImpl(this.bus, endpoint);
        } else {
            Endpoint endpoint = STSUtils.createSTSEndpoint(this.bus, this.namespace, null, this.location, this.soapVersion, this.policy, this.endpointName);
            this.client = new ClientImpl(this.bus, endpoint);
        }
        this.client.getInFaultInterceptors().addAll(this.inFault);
        this.client.getInInterceptors().addAll(this.in);
        this.client.getOutInterceptors().addAll(this.out);
        this.client.getOutFaultInterceptors().addAll(this.outFault);
        this.in = null;
        this.out = null;
        this.inFault = null;
        this.outFault = null;
        if (this.features != null) {
            for (AbstractFeature f : this.features) {
                f.initialize(this.client, this.bus);
            }
        }
    }

    private BindingOperationInfo findOperation(String suffix) {
        BindingInfo bi = this.client.getEndpoint().getBinding().getBindingInfo();
        for (BindingOperationInfo boi : bi.getOperations()) {
            SoapOperationInfo soi = boi.getExtensor(SoapOperationInfo.class);
            if (soi == null || soi.getAction() == null || !soi.getAction().endsWith(suffix)) continue;
            PolicyEngine pe = this.bus.getExtension(PolicyEngine.class);
            Conduit conduit = this.client.getConduit();
            EffectivePolicy effectivePolicy = pe.getEffectiveClientRequestPolicy(this.client.getEndpoint().getEndpointInfo(), boi, conduit);
            this.setPolicyInternal(effectivePolicy.getPolicy());
            return boi;
        }
        for (BindingOperationInfo boi : bi.getOperations()) {
            MessagePartInfo mpi;
            if (boi.getInput().getMessageInfo().getMessageParts().size() <= 0 || !"RequestSecurityToken".equals((mpi = boi.getInput().getMessageInfo().getMessagePart(0)).getConcreteName().getLocalPart())) continue;
            return boi;
        }
        return null;
    }

    public SecurityToken requestSecurityToken() throws Exception {
        return this.requestSecurityToken(null);
    }

    public SecurityToken requestSecurityToken(String appliesTo) throws Exception {
        String action = null;
        if (this.isSecureConv) {
            action = this.namespace + "/RST/SCT";
        }
        return this.requestSecurityToken(appliesTo, action, "/Issue", null);
    }

    public SecurityToken requestSecurityToken(String appliesTo, String action, String requestType, SecurityToken target) throws Exception {
        Element actAsSecurityToken;
        Element onBehalfOfToken;
        this.createClient();
        BindingOperationInfo boi = this.findOperation("/RST/Issue");
        this.client.getRequestContext().putAll(this.ctx);
        if (action != null) {
            this.client.getRequestContext().put("SOAPAction", action);
        } else {
            this.client.getRequestContext().put("SOAPAction", this.namespace + "/RST/Issue");
        }
        W3CDOMStreamWriter writer = new W3CDOMStreamWriter();
        writer.writeStartElement("wst", "RequestSecurityToken", this.namespace);
        writer.writeNamespace("wst", this.namespace);
        if (this.context != null) {
            writer.writeAttribute(null, "Context", this.context);
        }
        boolean wroteKeySize = false;
        String keyTypeTemplate = null;
        String sptt = null;
        if (this.template != null) {
            if (this.useSecondaryParameters()) {
                writer.writeStartElement("wst", "SecondaryParameters", this.namespace);
            }
            Element tl = DOMUtils.getFirstElement(this.template);
            while (tl != null) {
                StaxUtils.copy(tl, (XMLStreamWriter)writer);
                if ("KeyType".equals(tl.getLocalName())) {
                    keyTypeTemplate = DOMUtils.getContent(tl);
                } else if ("KeySize".equals(tl.getLocalName())) {
                    wroteKeySize = true;
                    this.keySize = Integer.parseInt(DOMUtils.getContent(tl));
                } else if ("TokenType".equals(tl.getLocalName())) {
                    sptt = DOMUtils.getContent(tl);
                }
                tl = DOMUtils.getNextElement(tl);
            }
            if (this.useSecondaryParameters()) {
                writer.writeEndElement();
            }
        }
        this.addRequestType(requestType, writer);
        if (this.enableAppliesTo) {
            this.addAppliesTo(writer, appliesTo);
        }
        if ((onBehalfOfToken = this.getOnBehalfOfToken()) != null) {
            writer.writeStartElement("wst", "OnBehalfOf", this.namespace);
            StaxUtils.copy(onBehalfOfToken, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
        if (sptt == null) {
            this.addTokenType(writer);
        }
        if (this.isSecureConv || this.enableLifetime) {
            this.addLifetime(writer);
        }
        if (keyTypeTemplate == null) {
            keyTypeTemplate = this.writeKeyType(writer, this.keyType);
        }
        byte[] requestorEntropy = null;
        X509Certificate cert = null;
        Crypto crypto = null;
        if (this.keySize <= 0) {
            this.keySize = 256;
        }
        if (keyTypeTemplate != null && keyTypeTemplate.endsWith("SymmetricKey")) {
            requestorEntropy = this.writeElementsForRSTSymmetricKey(writer, wroteKeySize);
        } else if (keyTypeTemplate != null && keyTypeTemplate.endsWith("PublicKey")) {
            crypto = this.createCrypto(false);
            cert = this.getCert(crypto);
            this.writeElementsForRSTPublicKey(writer, cert);
        }
        if (target != null) {
            writer.writeStartElement("wst", "RenewTarget", this.namespace);
            Element el = target.getUnattachedReference();
            if (el == null) {
                el = target.getAttachedReference();
            }
            StaxUtils.copy(el, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
        if ((actAsSecurityToken = this.getActAsToken()) != null) {
            writer.writeStartElement("http://docs.oasis-open.org/ws-sx/ws-trust/200802", "ActAs");
            StaxUtils.copy(actAsSecurityToken, (XMLStreamWriter)writer);
            writer.writeEndElement();
        }
        writer.writeEndElement();
        Object[] obj = this.client.invoke(boi, new DOMSource(writer.getDocument().getDocumentElement()));
        SecurityToken token = this.createSecurityToken(this.getDocumentElement((DOMSource)obj[0]), requestorEntropy);
        if (cert != null) {
            token.setX509Certificate(cert, crypto);
        }
        if (token.getTokenType() == null) {
            if (sptt != null) {
                token.setTokenType(sptt);
            } else if (this.tokenType != null) {
                token.setTokenType(this.tokenType);
            }
        }
        return token;
    }

    public Element getOnBehalfOfToken() throws Exception {
        return this.getDelegationSecurityToken(this.onBehalfOf);
    }

    public Element getActAsToken() throws Exception {
        return this.getDelegationSecurityToken(this.actAs);
    }

    private Element getDelegationSecurityToken(Object delegationObject) throws Exception {
        if (delegationObject != null) {
            boolean isString = delegationObject instanceof String;
            boolean isElement = delegationObject instanceof Element;
            boolean isCallbackHandler = delegationObject instanceof CallbackHandler;
            if (isString || isElement || isCallbackHandler) {
                if (isString) {
                    Document doc = DOMUtils.readXml(new StringReader((String)delegationObject));
                    return doc.getDocumentElement();
                }
                if (isElement) {
                    return (Element)delegationObject;
                }
                DelegationCallback callback = new DelegationCallback(this.message);
                ((CallbackHandler)delegationObject).handle(new Callback[]{callback});
                return callback.getToken();
            }
        }
        return null;
    }

    private byte[] writeElementsForRSTSymmetricKey(W3CDOMStreamWriter writer, boolean wroteKeySize) throws Exception {
        byte[] requestorEntropy = null;
        if (!(wroteKeySize || this.isSecureConv && this.keySize == 256)) {
            writer.writeStartElement("wst", "KeySize", this.namespace);
            writer.writeCharacters(Integer.toString(this.keySize));
            writer.writeEndElement();
        }
        if (this.requiresEntropy) {
            writer.writeStartElement("wst", "Entropy", this.namespace);
            writer.writeStartElement("wst", "BinarySecret", this.namespace);
            writer.writeAttribute("Type", this.namespace + "/Nonce");
            requestorEntropy = this.algorithmSuite == null ? WSSecurityUtil.generateNonce((int)(this.keySize / 8)) : WSSecurityUtil.generateNonce((int)(this.algorithmSuite.getMaximumSymmetricKeyLength() / 8));
            writer.writeCharacters(Base64.encode((byte[])requestorEntropy));
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeStartElement("wst", "ComputedKeyAlgorithm", this.namespace);
            writer.writeCharacters(this.namespace + "/CK/PSHA1");
            writer.writeEndElement();
        }
        return requestorEntropy;
    }

    private void writeElementsForRSTPublicKey(W3CDOMStreamWriter writer, X509Certificate cert) throws Exception {
        writer.writeStartElement("wst", "UseKey", this.namespace);
        writer.writeStartElement("dsig", "KeyInfo", "http://www.w3.org/2000/09/xmldsig#");
        writer.writeNamespace("dsig", "http://www.w3.org/2000/09/xmldsig#");
        boolean useCert = this.useCertificateForConfirmationKeyInfo;
        String useCertStr = (String)this.getProperty("ws-security.sts.token.usecert");
        if (useCertStr != null) {
            useCert = Boolean.parseBoolean(useCertStr);
        }
        if (useCert) {
            X509Data certElem = new X509Data(writer.getDocument());
            certElem.addCertificate(cert);
            writer.getCurrentNode().appendChild(certElem.getElement());
        } else {
            writer.writeStartElement("dsig", "KeyValue", "http://www.w3.org/2000/09/xmldsig#");
            PublicKey key = cert.getPublicKey();
            String pubKeyAlgo = key.getAlgorithm();
            if ("DSA".equalsIgnoreCase(pubKeyAlgo)) {
                DSAKeyValue dsaKeyValue = new DSAKeyValue(writer.getDocument(), (Key)key);
                writer.getCurrentNode().appendChild(dsaKeyValue.getElement());
            } else if ("RSA".equalsIgnoreCase(pubKeyAlgo)) {
                RSAKeyValue rsaKeyValue = new RSAKeyValue(writer.getDocument(), (Key)key);
                writer.getCurrentNode().appendChild(rsaKeyValue.getElement());
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
        writer.writeEndElement();
    }

    private void addRequestType(String requestType, W3CDOMStreamWriter writer) throws XMLStreamException {
        writer.writeStartElement("wst", "RequestType", this.namespace);
        writer.writeCharacters(this.namespace + requestType);
        writer.writeEndElement();
    }

    private Element getDocumentElement(DOMSource ds) {
        Node nd = ds.getNode();
        if (nd instanceof Document) {
            nd = ((Document)nd).getDocumentElement();
        }
        return (Element)nd;
    }

    public void renewSecurityToken(SecurityToken tok) throws Exception {
        String action = null;
        if (this.isSecureConv) {
            action = this.namespace + "/RST/SCT/Renew";
        }
        this.requestSecurityToken(tok.getIssuerAddress(), action, "/Renew", tok);
    }

    private PrimitiveAssertion getAddressingAssertion() {
        String ns = "http://schemas.xmlsoap.org/ws/2004/08/addressing/policy";
        String local = "UsingAddressing";
        if ("http://www.w3.org/2005/08/addressing".equals(this.addressingNamespace)) {
            ns = "http://www.w3.org/2007/02/addressing/metadata";
            local = "Addressing";
        }
        return new PrimitiveAssertion(new QName(ns, local), true);
    }

    public List<SecurityToken> validateSecurityToken(SecurityToken tok) throws Exception {
        String validateTokenType = this.tokenType;
        if (validateTokenType == null) {
            validateTokenType = this.namespace + "/RSTR/Status";
        }
        return this.validateSecurityToken(tok, validateTokenType);
    }

    private List<SecurityToken> validateSecurityToken(SecurityToken tok, String tokentype) throws Exception {
        this.createClient();
        if (tokentype == null) {
            tokentype = this.tokenType;
        }
        if (tokentype == null) {
            tokentype = this.namespace + "/RSTR/Status";
        }
        if (this.addressingNamespace == null) {
            this.addressingNamespace = "http://www.w3.org/2005/08/addressing";
        }
        Policy validatePolicy = new Policy();
        ExactlyOne one = new ExactlyOne();
        validatePolicy.addPolicyComponent((PolicyComponent)one);
        All all = new All();
        one.addPolicyComponent((PolicyComponent)all);
        all.addAssertion((Assertion)this.getAddressingAssertion());
        this.client.getRequestContext().clear();
        this.client.getRequestContext().putAll(this.ctx);
        this.client.getRequestContext().put("ws-security.token", tok);
        BindingOperationInfo boi = this.findOperation("/RST/Validate");
        if (boi == null) {
            boi = this.findOperation("/RST/Issue");
            this.client.getRequestContext().put("org.apache.cxf.ws.policy.override", validatePolicy);
        }
        this.client.getRequestContext().put("SOAPAction", this.namespace + "/RST/Validate");
        W3CDOMStreamWriter writer = new W3CDOMStreamWriter();
        writer.writeStartElement("wst", "RequestSecurityToken", this.namespace);
        writer.writeNamespace("wst", this.namespace);
        writer.writeStartElement("wst", "RequestType", this.namespace);
        writer.writeCharacters(this.namespace + "/Validate");
        writer.writeEndElement();
        writer.writeStartElement("wst", "TokenType", this.namespace);
        writer.writeCharacters(tokentype);
        writer.writeEndElement();
        writer.writeStartElement("wst", "ValidateTarget", this.namespace);
        Element el = tok.getToken();
        StaxUtils.copy(el, (XMLStreamWriter)writer);
        writer.writeEndElement();
        writer.writeEndElement();
        Object[] o = this.client.invoke(boi, new DOMSource(writer.getDocument().getDocumentElement()));
        el = this.getDocumentElement((DOMSource)o[0]);
        if ("RequestSecurityTokenResponseCollection".equals(el.getLocalName())) {
            el = DOMUtils.getFirstElement(el);
        }
        if (!"RequestSecurityTokenResponse".equals(el.getLocalName())) {
            throw new Fault("Unexpected element " + el.getLocalName(), LOG);
        }
        el = DOMUtils.getFirstElement(el);
        String reason = null;
        boolean valid = false;
        LinkedList<SecurityToken> tokens = new LinkedList<SecurityToken>();
        while (el != null) {
            if ("Status".equals(el.getLocalName())) {
                Element e2 = DOMUtils.getFirstChildWithName(el, el.getNamespaceURI(), "Code");
                String s = DOMUtils.getContent(e2);
                valid = s.endsWith("/status/valid");
                e2 = DOMUtils.getFirstChildWithName(el, el.getNamespaceURI(), "Reason");
                if (e2 != null) {
                    reason = DOMUtils.getContent(e2);
                }
            } else if ("RequestedSecurityToken".equals(el.getLocalName())) {
                Element requestedSecurityTokenElement = DOMUtils.getFirstElement(el);
                String id = this.findID(null, null, requestedSecurityTokenElement);
                if (StringUtils.isEmpty(id)) {
                    throw new TrustException("NO_ID", LOG);
                }
                SecurityToken requestedSecurityToken = new SecurityToken(id);
                requestedSecurityToken.setToken(requestedSecurityTokenElement);
                tokens.add(requestedSecurityToken);
            }
            el = DOMUtils.getNextElement(el);
        }
        if (!valid) {
            throw new TrustException(LOG, "VALIDATION_FAILED", reason);
        }
        if (tokens.isEmpty()) {
            tokens.add(tok);
        }
        return tokens;
    }

    public boolean cancelSecurityToken(SecurityToken token) throws Exception {
        this.createClient();
        if (this.addressingNamespace == null) {
            this.addressingNamespace = "http://www.w3.org/2005/08/addressing";
        }
        this.client.getRequestContext().clear();
        this.client.getRequestContext().putAll(this.ctx);
        this.client.getRequestContext().put("ws-security.token", token);
        BindingOperationInfo boi = this.findOperation("/RST/Cancel");
        boolean attachTokenDirectly = true;
        if (boi == null) {
            attachTokenDirectly = false;
            boi = this.findOperation("/RST/Issue");
            Policy cancelPolicy = new Policy();
            ExactlyOne one = new ExactlyOne();
            cancelPolicy.addPolicyComponent((PolicyComponent)one);
            All all = new All();
            one.addPolicyComponent((PolicyComponent)all);
            all.addAssertion((Assertion)this.getAddressingAssertion());
            PolicyBuilder pbuilder = this.bus.getExtension(PolicyBuilder.class);
            SymmetricBinding binding = new SymmetricBinding(pbuilder);
            all.addAssertion((Assertion)binding);
            all.addAssertion((Assertion)this.getAddressingAssertion());
            ProtectionToken ptoken = new ProtectionToken(pbuilder);
            binding.setProtectionToken(ptoken);
            binding.setIncludeTimestamp(true);
            binding.setEntireHeadersAndBodySignatures(true);
            binding.setTokenProtection(false);
            AlgorithmSuite suite = new AlgorithmSuite();
            binding.setAlgorithmSuite(suite);
            SecureConversationToken sct = new SecureConversationToken();
            sct.setOptional(true);
            ptoken.setToken(sct);
            SignedEncryptedParts parts = new SignedEncryptedParts(true);
            parts.setOptional(true);
            parts.setBody(true);
            parts.addHeader(new Header("To", this.addressingNamespace));
            parts.addHeader(new Header("From", this.addressingNamespace));
            parts.addHeader(new Header("FaultTo", this.addressingNamespace));
            parts.addHeader(new Header("ReplyTo", this.addressingNamespace));
            parts.addHeader(new Header("Action", this.addressingNamespace));
            parts.addHeader(new Header("MessageID", this.addressingNamespace));
            parts.addHeader(new Header("RelatesTo", this.addressingNamespace));
            all.addPolicyComponent((PolicyComponent)parts);
            this.client.getRequestContext().put("org.apache.cxf.ws.policy.override", cancelPolicy);
        }
        if (this.isSecureConv) {
            this.client.getRequestContext().put("SOAPAction", this.namespace + "/RST/SCT/Cancel");
        } else {
            this.client.getRequestContext().put("SOAPAction", this.namespace + "/RST/Cancel");
        }
        W3CDOMStreamWriter writer = new W3CDOMStreamWriter();
        writer.writeStartElement("wst", "RequestSecurityToken", this.namespace);
        writer.writeNamespace("wst", this.namespace);
        writer.writeStartElement("wst", "RequestType", this.namespace);
        writer.writeCharacters(this.namespace + "/Cancel");
        writer.writeEndElement();
        writer.writeStartElement("wst", "CancelTarget", this.namespace);
        Element el = null;
        if (attachTokenDirectly) {
            el = token.getToken();
        } else {
            el = token.getUnattachedReference();
            if (el == null) {
                el = token.getAttachedReference();
            }
        }
        StaxUtils.copy(el, (XMLStreamWriter)writer);
        writer.writeEndElement();
        writer.writeEndElement();
        try {
            this.client.invoke(boi, new DOMSource(writer.getDocument().getDocumentElement()));
            token.setState(SecurityToken.State.CANCELLED);
            return true;
        }
        catch (Exception ex) {
            LOG.log(Level.WARNING, "Problem cancelling token", ex);
            return false;
        }
    }

    private boolean useSecondaryParameters() {
        return !"http://schemas.xmlsoap.org/ws/2005/02/trust".equals(this.namespace);
    }

    private String writeKeyType(W3CDOMStreamWriter writer, String keyTypeToWrite) throws XMLStreamException {
        if (this.isSecureConv) {
            if (keyTypeToWrite == null) {
                writer.writeStartElement("wst", "TokenType", this.namespace);
                writer.writeCharacters(STSUtils.getTokenTypeSCT(this.namespace));
                writer.writeEndElement();
                keyTypeToWrite = this.namespace + "/SymmetricKey";
            }
        } else if (keyTypeToWrite == null && this.sendKeyType) {
            writer.writeStartElement("wst", "KeyType", this.namespace);
            writer.writeCharacters(this.namespace + "/SymmetricKey");
            writer.writeEndElement();
            keyTypeToWrite = this.namespace + "/SymmetricKey";
        } else if (keyTypeToWrite != null) {
            writer.writeStartElement("wst", "KeyType", this.namespace);
            writer.writeCharacters(keyTypeToWrite);
            writer.writeEndElement();
        }
        return keyTypeToWrite;
    }

    private X509Certificate getCert(Crypto crypto) throws Exception {
        String alias = (String)this.getProperty("ws-security.sts.token.username");
        if (alias == null) {
            alias = crypto.getDefaultX509Identifier();
        }
        if (alias == null) {
            throw new Fault("No alias specified for retrieving PublicKey", LOG);
        }
        CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ALIAS);
        cryptoType.setAlias(alias);
        X509Certificate[] certs = crypto.getX509Certificates(cryptoType);
        if (certs == null || certs.length == 0) {
            throw new Fault("Could not get X509Certificate for alias " + alias, LOG);
        }
        return certs[0];
    }

    private void addLifetime(XMLStreamWriter writer) throws XMLStreamException {
        Date creationTime = new Date();
        Date expirationTime = new Date();
        expirationTime.setTime(creationTime.getTime() + (long)this.ttl * 1000L);
        XmlSchemaDateFormat fmt = new XmlSchemaDateFormat();
        writer.writeStartElement("wst", "Lifetime", this.namespace);
        writer.writeNamespace("wsu", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        writer.writeStartElement("wsu", "Created", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        writer.writeCharacters(fmt.format(creationTime));
        writer.writeEndElement();
        writer.writeStartElement("wsu", "Expires", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        writer.writeCharacters(fmt.format(expirationTime));
        writer.writeEndElement();
        writer.writeEndElement();
    }

    private void addAppliesTo(XMLStreamWriter writer, String appliesTo) throws XMLStreamException {
        if (appliesTo != null && this.addressingNamespace != null) {
            writer.writeStartElement("wsp", "AppliesTo", "http://schemas.xmlsoap.org/ws/2004/09/policy");
            writer.writeNamespace("wsp", "http://schemas.xmlsoap.org/ws/2004/09/policy");
            writer.writeStartElement("wsa", "EndpointReference", this.addressingNamespace);
            writer.writeNamespace("wsa", this.addressingNamespace);
            writer.writeStartElement("wsa", "Address", this.addressingNamespace);
            writer.writeCharacters(appliesTo);
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndElement();
        }
    }

    private void addTokenType(XMLStreamWriter writer) throws XMLStreamException {
        if (this.tokenType != null) {
            writer.writeStartElement("wst", "TokenType", this.namespace);
            writer.writeCharacters(this.tokenType);
            writer.writeEndElement();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private SecurityToken createSecurityToken(Element el, byte[] requestorEntropy) throws WSSecurityException {
        if ("RequestSecurityTokenResponseCollection".equals(el.getLocalName())) {
            el = DOMUtils.getFirstElement(el);
        }
        if (!"RequestSecurityTokenResponse".equals(el.getLocalName())) {
            throw new Fault("Unexpected element " + el.getLocalName(), LOG);
        }
        el = DOMUtils.getFirstElement(el);
        Element rst = null;
        Element rar = null;
        Element rur = null;
        Element rpt = null;
        Element lte = null;
        Element entropy = null;
        String tt = null;
        while (el != null) {
            String ln = el.getLocalName();
            if (this.namespace.equals(el.getNamespaceURI())) {
                if ("Lifetime".equals(ln)) {
                    lte = el;
                } else if ("RequestedSecurityToken".equals(ln)) {
                    rst = DOMUtils.getFirstElement(el);
                } else if ("RequestedAttachedReference".equals(ln)) {
                    rar = DOMUtils.getFirstElement(el);
                } else if ("RequestedUnattachedReference".equals(ln)) {
                    rur = DOMUtils.getFirstElement(el);
                } else if ("RequestedProofToken".equals(ln)) {
                    rpt = el;
                } else if ("Entropy".equals(ln)) {
                    entropy = el;
                } else if ("TokenType".equals(ln)) {
                    tt = DOMUtils.getContent(el);
                }
            }
            el = DOMUtils.getNextElement(el);
        }
        Element rstDec = rst;
        String id = this.findID(rar, rur, rstDec);
        if (StringUtils.isEmpty(id)) {
            throw new TrustException("NO_ID", LOG);
        }
        SecurityToken token = new SecurityToken(id, rstDec, lte);
        token.setAttachedReference(rar);
        token.setUnattachedReference(rur);
        token.setIssuerAddress(this.location);
        token.setTokenType(tt);
        byte[] secret = null;
        if (rpt != null) {
            Element child = DOMUtils.getFirstElement(rpt);
            QName childQname = DOMUtils.getElementQName(child);
            if (childQname.equals(new QName(this.namespace, "BinarySecret"))) {
                String b64Secret = DOMUtils.getContent(child);
                secret = Base64.decode((String)b64Secret);
            } else if (childQname.equals(new QName("http://www.w3.org/2001/04/xmlenc#", "EncryptedKey"))) {
                secret = this.decryptKey(child);
            } else if (childQname.equals(new QName(this.namespace, "ComputedKey"))) {
                int length;
                Element computedKeyChild = entropy == null ? null : DOMUtils.getFirstElement(entropy);
                byte[] serviceEntr = null;
                if (computedKeyChild != null) {
                    QName computedKeyChildQName = DOMUtils.getElementQName(computedKeyChild);
                    if (computedKeyChildQName.equals(new QName("http://www.w3.org/2001/04/xmlenc#", "EncryptedKey"))) {
                        serviceEntr = this.decryptKey(computedKeyChild);
                    } else if (computedKeyChildQName.equals(new QName(this.namespace, "BinarySecret"))) {
                        String content = DOMUtils.getContent(computedKeyChild);
                        serviceEntr = Base64.decode((String)content);
                    }
                }
                if (serviceEntr == null) throw new TrustException("NO_ENTROPY", LOG);
                P_SHA1 psha1 = new P_SHA1();
                int n = length = this.keySize > 0 ? this.keySize : 256;
                if (this.algorithmSuite != null) {
                    length = this.keySize > 0 ? this.keySize : this.algorithmSuite.getMaximumSymmetricKeyLength();
                }
                try {
                    secret = psha1.createKey(requestorEntropy, serviceEntr, 0, (long)(length / 8));
                }
                catch (ConversationException e) {
                    throw new TrustException("DERIVED_KEY_ERROR", LOG, e);
                }
            }
        } else if (requestorEntropy != null) {
            secret = requestorEntropy;
        }
        token.setSecret(secret);
        return token;
    }

    private byte[] decryptKey(Element child) throws TrustException, WSSecurityException {
        try {
            EncryptedKeyProcessor proc = new EncryptedKeyProcessor();
            WSDocInfo docInfo = new WSDocInfo(child.getOwnerDocument());
            RequestData data = new RequestData();
            data.setWssConfig(WSSConfig.getNewInstance());
            data.setDecCrypto(this.createCrypto(true));
            data.setCallbackHandler(this.createHandler());
            List result = proc.handleToken(child, data, docInfo);
            return (byte[])((WSSecurityEngineResult)result.get(0)).get((Object)"secret");
        }
        catch (IOException e) {
            throw new TrustException("ENCRYPTED_KEY_ERROR", LOG, e);
        }
    }

    private CallbackHandler createHandler() {
        Object o = this.getProperty("ws-security.callback-handler");
        if (o instanceof String) {
            try {
                Class<?> cls = ClassLoaderUtils.loadClass((String)o, this.getClass());
                o = cls.newInstance();
            }
            catch (Exception e) {
                throw new Fault(e);
            }
        }
        return (CallbackHandler)o;
    }

    private Object getProperty(String s) {
        Object o = this.ctx.get(s);
        if (o == null) {
            o = this.client.getEndpoint().getEndpointInfo().getProperty(s);
        }
        if (o == null) {
            o = this.client.getEndpoint().getEndpointInfo().getBinding().getProperty(s);
        }
        if (o == null) {
            o = this.client.getEndpoint().getService().get(s);
        }
        return o;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Crypto createCrypto(boolean decrypt) throws IOException, WSSecurityException {
        Crypto crypto = (Crypto)this.getProperty("ws-security.sts.token.crypto" + (decrypt ? ".decrypt" : ""));
        if (crypto != null) {
            return crypto;
        }
        Object o = this.getProperty("ws-security.sts.token.properties" + (decrypt ? ".decrypt" : ""));
        Properties properties = null;
        if (o instanceof Properties) {
            properties = (Properties)o;
        } else if (o instanceof String) {
            ResourceManager rm = this.bus.getExtension(ResourceManager.class);
            URL url = rm.resolveResource((String)o, URL.class);
            if (url == null) {
                url = ClassLoaderUtils.getResource((String)o, this.getClass());
            }
            if (url == null) throw new Fault("Could not find properties file " + (String)o, LOG);
            properties = new Properties();
            InputStream ins = url.openStream();
            properties.load(ins);
            ins.close();
        } else if (o instanceof URL) {
            properties = new Properties();
            InputStream ins = ((URL)o).openStream();
            properties.load(ins);
            ins.close();
        }
        if (properties != null) {
            return CryptoFactory.getInstance((Properties)properties);
        }
        if (!decrypt) return null;
        return this.createCrypto(false);
    }

    private String findID(Element rar, Element rur, Element rst) {
        String id = null;
        if (rst != null) {
            QName elName = DOMUtils.getElementQName(rst);
            if (elName.equals(new QName("urn:oasis:names:tc:SAML:1.0:assertion", "Assertion")) && rst.hasAttributeNS(null, "AssertionID")) {
                id = rst.getAttributeNS(null, "AssertionID");
            } else if (elName.equals(new QName("urn:oasis:names:tc:SAML:2.0:assertion", "Assertion")) && rst.hasAttributeNS(null, "ID")) {
                id = rst.getAttributeNS(null, "ID");
            }
            if (id == null) {
                id = this.getIDFromSTR(rst);
            }
        }
        if (id == null && rar != null) {
            id = this.getIDFromSTR(rar);
        }
        if (id == null && rur != null) {
            id = this.getIDFromSTR(rur);
        }
        if (id == null) {
            id = rst.getAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id");
        }
        return id;
    }

    private String getIDFromSTR(Element el) {
        Element child = DOMUtils.getFirstElement(el);
        if (child == null) {
            return null;
        }
        QName elName = DOMUtils.getElementQName(child);
        if (elName.equals(new QName("http://www.w3.org/2000/09/xmldsig#", "KeyInfo")) || elName.equals(new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "KeyIdentifier"))) {
            return DOMUtils.getContent(child);
        }
        if (elName.equals(Reference.TOKEN)) {
            return child.getAttribute("URI");
        }
        if (elName.equals(new QName("http://schemas.xmlsoap.org/ws/2005/02/sc", "Identifier")) || elName.equals(new QName("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512", "Identifier"))) {
            return DOMUtils.getContent(child);
        }
        return null;
    }

    public void setTemplate(Element rstTemplate) {
        this.template = rstTemplate;
    }

    @Override
    public List<Interceptor<? extends Message>> getOutFaultInterceptors() {
        if (this.client != null) {
            return this.client.getOutFaultInterceptors();
        }
        return this.outFault;
    }

    @Override
    public List<Interceptor<? extends Message>> getInFaultInterceptors() {
        if (this.client != null) {
            return this.client.getInFaultInterceptors();
        }
        return this.inFault;
    }

    @Override
    public List<Interceptor<? extends Message>> getInInterceptors() {
        if (this.client != null) {
            return this.client.getInInterceptors();
        }
        return this.in;
    }

    @Override
    public List<Interceptor<? extends Message>> getOutInterceptors() {
        if (this.client != null) {
            return this.client.getOutInterceptors();
        }
        return this.out;
    }

    public void setInInterceptors(List<Interceptor<? extends Message>> interceptors) {
        this.getInInterceptors().addAll(interceptors);
    }

    public void setInFaultInterceptors(List<Interceptor<? extends Message>> interceptors) {
        this.getInFaultInterceptors().addAll(interceptors);
    }

    public void setOutInterceptors(List<Interceptor<? extends Message>> interceptors) {
        this.getOutInterceptors().addAll(interceptors);
    }

    public void setOutFaultInterceptors(List<Interceptor<? extends Message>> interceptors) {
        this.getOutFaultInterceptors().addAll(interceptors);
    }

    public void setFeatures(List<AbstractFeature> f) {
        this.features = f;
    }

    public List<AbstractFeature> getFeatures() {
        return this.features;
    }
}

