/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.wss4j.policyvalidators;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.cxf.message.Message;
import org.apache.cxf.ws.policy.AssertionInfo;
import org.apache.cxf.ws.policy.AssertionInfoMap;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.model.X509Token;
import org.apache.cxf.ws.security.wss4j.policyvalidators.AbstractTokenPolicyValidator;
import org.apache.ws.security.WSSecurityEngineResult;
import org.apache.ws.security.message.token.BinarySecurity;
import org.apache.ws.security.util.WSSecurityUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class X509TokenPolicyValidator
extends AbstractTokenPolicyValidator {
    private static final String X509_V3_VALUETYPE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3";
    private static final String PKI_VALUETYPE = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509PKIPathv1";
    private List<WSSecurityEngineResult> bstResults;
    private Message message;

    public X509TokenPolicyValidator(Message message, List<WSSecurityEngineResult> results) {
        this.message = message;
        this.bstResults = new ArrayList<WSSecurityEngineResult>();
        WSSecurityUtil.fetchAllActionResults(results, (int)4096, this.bstResults);
    }

    public boolean validatePolicy(AssertionInfoMap aim) {
        Collection x509Ais = (Collection)aim.get(SP12Constants.X509_TOKEN);
        if (x509Ais != null && !x509Ais.isEmpty()) {
            for (AssertionInfo ai : x509Ais) {
                X509Token x509TokenPolicy = (X509Token)ai.getAssertion();
                ai.setAsserted(true);
                if (!this.isTokenRequired(x509TokenPolicy, this.message)) continue;
                if (this.bstResults.isEmpty()) {
                    ai.setNotAsserted("The received token does not match the token inclusion requirement");
                    return false;
                }
                if (this.checkTokenType(x509TokenPolicy.getTokenVersionAndType())) continue;
                ai.setNotAsserted("An incorrect X.509 Token Type is detected");
                return false;
            }
        }
        return true;
    }

    private boolean checkTokenType(String requiredVersionAndType) {
        if (!this.bstResults.isEmpty()) {
            String requiredType = X509_V3_VALUETYPE;
            if ("WssX509PkiPathV1Token10".equals(requiredType) || "WssX509PkiPathV1Token11".equals(requiredType)) {
                requiredType = PKI_VALUETYPE;
            }
            for (WSSecurityEngineResult result : this.bstResults) {
                String type;
                BinarySecurity binarySecurityToken = (BinarySecurity)result.get((Object)"binary-security-token");
                if (binarySecurityToken == null || !requiredType.equals(type = binarySecurityToken.getValueType())) continue;
                return true;
            }
        }
        return false;
    }
}

