/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.corba.common.idltypes;

import java.io.PrintWriter;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import org.apache.cxf.tools.corba.common.idltypes.IdlException;
import org.apache.cxf.tools.corba.common.idltypes.IdlParam;
import org.apache.cxf.tools.corba.common.idltypes.IdlScopeBase;
import org.apache.cxf.tools.corba.common.idltypes.IdlScopedName;
import org.apache.cxf.tools.corba.common.idltypes.IdlType;

public final class IdlOperation
extends IdlScopeBase {
    private IdlType returnType;
    private List<Object> exceptions = new Vector<Object>();
    private boolean oneway;

    private IdlOperation(IdlScopeBase parent, String name, boolean isOneway) {
        super(parent, name);
        this.oneway = isOneway;
    }

    public static IdlOperation create(IdlScopeBase parent, String name, boolean isOneway) {
        return new IdlOperation(parent, name, isOneway);
    }

    public void addParameter(IdlParam arg) {
        super.addToScope(arg);
    }

    public void addReturnType(IdlType rt) {
        this.returnType = rt;
    }

    public void addException(IdlException exc) {
        this.exceptions.add(exc);
    }

    public void write(PrintWriter pw) {
        int needComma;
        IdlScopedName sn = this.scopeName();
        pw.print(IdlOperation.indent());
        if (this.returnType != null && !this.returnType.isEmptyDef()) {
            pw.println(this.returnType.fullName(sn));
        } else {
            if (this.oneway) {
                pw.print("oneway ");
            }
            pw.println("void");
        }
        pw.print(IdlOperation.indent() + this.localName() + "(");
        Collection defns = this.definitions();
        if (defns.size() != 0) {
            pw.println();
            IdlOperation.indentMore();
            needComma = defns.size() - 1;
            for (IdlParam idlParam : defns) {
                idlParam.write(pw);
                if (needComma-- == 0 || idlParam.isEmptyDef()) continue;
                pw.println(",");
            }
            pw.println();
            IdlOperation.indentLess();
            pw.print(IdlOperation.indent());
        }
        if (this.exceptions.isEmpty()) {
            pw.println(");");
        } else {
            pw.println(") raises(");
            IdlOperation.indentMore();
            needComma = this.exceptions.size() - 1;
            for (IdlException idlException : this.exceptions) {
                pw.print(IdlOperation.indent() + idlException.fullName(this.scopeName()));
                if (needComma-- == 0) continue;
                pw.println(",");
            }
            pw.println();
            IdlOperation.indentLess();
            pw.println(IdlOperation.indent() + ");");
        }
    }
}

