/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.bus.extension;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.cxf.Bus;
import org.apache.cxf.bus.extension.Extension;
import org.apache.cxf.bus.extension.ExtensionException;
import org.apache.cxf.bus.extension.ExtensionFragmentParser;
import org.apache.cxf.bus.extension.ExtensionManager;
import org.apache.cxf.common.injection.ResourceInjector;
import org.apache.cxf.configuration.Configurer;
import org.apache.cxf.resource.ObjectTypeResolver;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.resource.SinglePropertyResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionManagerImpl
implements ExtensionManager {
    public static final String EXTENSIONMANAGER_PROPERTY_NAME = "extensionManager";
    public static final String ACTIVATION_NAMESPACES_PROPERTY_NAME = "activationNamespaces";
    public static final String ACTIVATION_NAMESPACES_SETTER_METHOD_NAME = "setActivationNamespaces";
    public static final String BUS_EXTENSION_RESOURCE_COMPAT = "META-INF/bus-extensions.xml";
    public static final String BUS_EXTENSION_RESOURCE = "META-INF/cxf/bus-extensions.xml";
    private final ClassLoader loader;
    private ResourceManager resourceManager;
    private Map<String, Collection<Extension>> deferred;
    private final Map<Class, Object> activated;
    private final Map<String, Collection<Object>> namespaced = new ConcurrentHashMap<String, Collection<Object>>();
    private final Bus bus;

    public ExtensionManagerImpl(ClassLoader cl, Map<Class, Object> initialExtensions, ResourceManager rm, Bus b) {
        this(new String[]{BUS_EXTENSION_RESOURCE, BUS_EXTENSION_RESOURCE_COMPAT}, cl, initialExtensions, rm, b);
    }

    public ExtensionManagerImpl(String resource, ClassLoader cl, Map<Class, Object> initialExtensions, ResourceManager rm, Bus b) {
        this(new String[]{resource}, cl, initialExtensions, rm, b);
    }

    public ExtensionManagerImpl(String[] resources, ClassLoader cl, Map<Class, Object> initialExtensions, ResourceManager rm, Bus b) {
        this.loader = cl;
        this.bus = b;
        this.activated = initialExtensions;
        this.resourceManager = rm;
        SinglePropertyResolver extensionManagerResolver = new SinglePropertyResolver(EXTENSIONMANAGER_PROPERTY_NAME, this);
        this.resourceManager.addResourceResolver(extensionManagerResolver);
        this.resourceManager.addResourceResolver(new ObjectTypeResolver(this));
        this.deferred = new ConcurrentHashMap<String, Collection<Extension>>();
        this.load(resources);
    }

    public final void load(String[] resources) {
        if (resources == null) {
            return;
        }
        try {
            for (String resource : resources) {
                this.load(resource);
            }
        }
        catch (IOException ex) {
            throw new ExtensionException(ex);
        }
    }

    @Override
    public synchronized void activateViaNS(String namespaceURI) {
        Collection<Extension> extensions = this.deferred.get(namespaceURI);
        if (null == extensions) {
            return;
        }
        for (Extension e : extensions) {
            this.loadAndRegister(e);
        }
        extensions.clear();
        this.deferred.remove(namespaceURI);
    }

    @Override
    public synchronized void activateAll() {
        while (!this.deferred.isEmpty()) {
            this.activateViaNS(this.deferred.keySet().iterator().next());
        }
    }

    @Override
    public synchronized <T> void activateAllByType(Class<T> type) {
        for (Map.Entry<String, Collection<Extension>> e : this.deferred.entrySet()) {
            if (e.getValue().isEmpty()) continue;
            ArrayList<Extension> removes = new ArrayList<Extension>(e.getValue().size());
            for (Extension ex : e.getValue()) {
                if (!type.isAssignableFrom(ex.getClassObject(this.loader))) continue;
                this.loadAndRegister(ex);
                removes.add(ex);
            }
            e.getValue().removeAll(removes);
        }
    }

    final void load(String resource) throws IOException {
        Enumeration<URL> urls = this.loader.getResources(resource);
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            InputStream is = url.openStream();
            this.loadFragment(is);
        }
    }

    final void loadFragment(InputStream is) {
        List<Extension> extensions = new ExtensionFragmentParser().getExtensions(is);
        for (Extension e : extensions) {
            this.processExtension(e);
        }
    }

    final void processExtension(Extension e) {
        if (!e.isDeferred()) {
            this.loadAndRegister(e);
        } else {
            Collection<String> namespaces = e.getNamespaces();
            for (String ns : namespaces) {
                Collection<Extension> extensions = this.deferred.get(ns);
                if (null == extensions) {
                    extensions = new CopyOnWriteArrayList<Extension>();
                    this.deferred.put(ns, extensions);
                }
                extensions.add(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void loadAndRegister(Extension e) {
        Class<?> cls = null;
        if (null != e.getInterfaceName() && !"".equals(e.getInterfaceName())) {
            cls = e.loadInterface(this.loader);
        }
        if (null != this.activated && null != cls && null != this.activated.get(cls)) {
            return;
        }
        Object obj = e.load(this.loader, this.bus);
        Configurer configurer = (Configurer)this.activated.get(Configurer.class);
        if (null != configurer) {
            configurer.configureBean(obj);
        }
        SinglePropertyResolver namespacesResolver = null;
        if (null != e.getNamespaces()) {
            namespacesResolver = new SinglePropertyResolver(ACTIVATION_NAMESPACES_PROPERTY_NAME, e.getNamespaces());
            this.resourceManager.addResourceResolver(namespacesResolver);
        }
        this.invokeSetterActivationNSMethod(obj, e.getNamespaces());
        ResourceInjector injector = new ResourceInjector(this.resourceManager);
        try {
            injector.inject(obj);
            injector.construct(obj);
        }
        finally {
            if (null != namespacesResolver) {
                this.resourceManager.removeResourceResolver(namespacesResolver);
            }
        }
        if (null != this.activated) {
            if (cls == null) {
                cls = obj.getClass();
            }
            this.activated.put(cls, obj);
        }
        for (String ns : e.getNamespaces()) {
            Collection<Object> intf2Obj = this.namespaced.get(ns);
            if (intf2Obj == null) {
                intf2Obj = new CopyOnWriteArrayList<Object>();
                if (!this.namespaced.containsKey(ns)) {
                    this.namespaced.put(ns, intf2Obj);
                }
            }
            intf2Obj.add(obj);
        }
    }

    @Override
    public <T> T getExtension(String ns, Class<T> type) {
        Collection<Object> nsExts = this.namespaced.get(ns);
        if (nsExts != null) {
            for (Object o : nsExts) {
                if (!type.isAssignableFrom(o.getClass())) continue;
                return type.cast(o);
            }
        }
        return null;
    }

    private void invokeSetterActivationNSMethod(Object target, Object value) {
        String methodName = ACTIVATION_NAMESPACES_SETTER_METHOD_NAME;
        for (Class<?> clazz = target.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            Method[] methods = clazz.getMethods();
            for (int i = 0; i < methods.length; ++i) {
                Class<?> paramType;
                Method method = methods[i];
                Class<?>[] params = method.getParameterTypes();
                if (!method.getName().equals(methodName) || params.length != 1 || !(paramType = params[0]).isInstance(value)) continue;
                try {
                    method.invoke(target, value);
                }
                catch (Exception e) {
                    // empty catch block
                }
                return;
            }
        }
    }
}

