/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.corba.processors.idl;

import antlr.collections.AST;
import javax.wsdl.Definition;
import org.apache.cxf.binding.corba.wsdl.CorbaTypeImpl;
import org.apache.cxf.binding.corba.wsdl.ModeType;
import org.apache.cxf.binding.corba.wsdl.OperationType;
import org.apache.cxf.binding.corba.wsdl.ParamType;
import org.apache.cxf.tools.corba.common.ReferenceConstants;
import org.apache.cxf.tools.corba.processors.idl.ParamDeferredAction;
import org.apache.cxf.tools.corba.processors.idl.ParamTypeSpecVisitor;
import org.apache.cxf.tools.corba.processors.idl.Scope;
import org.apache.cxf.tools.corba.processors.idl.TypesUtils;
import org.apache.cxf.tools.corba.processors.idl.VisitorBase;
import org.apache.cxf.tools.corba.processors.idl.WSDLASTVisitor;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaElement;
import org.apache.ws.commons.schema.XmlSchemaObject;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaType;

public class ParamDclVisitor
extends VisitorBase {
    private XmlSchemaSequence inWrappingSequence;
    private XmlSchemaSequence outWrappingSequence;
    private OperationType corbaOperation;

    public ParamDclVisitor(Scope scope, Definition defn, XmlSchema schemaRef, WSDLASTVisitor wsdlVisitor, XmlSchemaSequence inWrapSeq, XmlSchemaSequence outWrapSeq, OperationType corbaOp) {
        super(scope, defn, schemaRef, wsdlVisitor);
        this.inWrappingSequence = inWrapSeq;
        this.outWrappingSequence = outWrapSeq;
        this.corbaOperation = corbaOp;
    }

    public static boolean accept(AST node) {
        boolean result = false;
        if (node != null) {
            int type = node.getType();
            result = type == 25 || type == 70 || type == 71;
        }
        return result;
    }

    public void visit(AST node) {
        AST typeNode = node.getFirstChild();
        AST nameNode = TypesUtils.getCorbaTypeNameNode(typeNode);
        ParamTypeSpecVisitor visitor = new ParamTypeSpecVisitor(this.getScope(), this.definition, this.schema, this.wsdlVisitor);
        visitor.visit(typeNode);
        XmlSchemaType schemaType = visitor.getSchemaType();
        CorbaTypeImpl corbaType = visitor.getCorbaType();
        Scope fullyQualifiedName = visitor.getFullyQualifiedName();
        switch (node.getType()) {
            case 25: {
                this.addElement(this.inWrappingSequence, schemaType, nameNode.toString(), fullyQualifiedName);
                this.addCorbaParam(corbaType, ModeType.IN, nameNode.toString(), fullyQualifiedName);
                break;
            }
            case 70: {
                this.addElement(this.outWrappingSequence, schemaType, nameNode.toString(), fullyQualifiedName);
                this.addCorbaParam(corbaType, ModeType.OUT, nameNode.toString(), fullyQualifiedName);
                break;
            }
            case 71: {
                this.addElement(this.inWrappingSequence, schemaType, nameNode.toString(), fullyQualifiedName);
                this.addElement(this.outWrappingSequence, schemaType, nameNode.toString(), fullyQualifiedName);
                this.addCorbaParam(corbaType, ModeType.INOUT, nameNode.toString(), fullyQualifiedName);
                break;
            }
            default: {
                throw new RuntimeException("[ParamDclVisitor: illegal IDL!]");
            }
        }
        this.setSchemaType(schemaType);
        this.setCorbaType(corbaType);
    }

    private XmlSchemaElement addElement(XmlSchemaSequence schemaSequence, XmlSchemaType schemaType, String name, Scope fullyQualifiedName) {
        XmlSchemaElement element = new XmlSchemaElement();
        element.setName(name);
        if (schemaType == null) {
            ParamDeferredAction elementAction = this.mapper.isDefaultMapping() ? new ParamDeferredAction(element) : new ParamDeferredAction(element, fullyQualifiedName.getParent(), this.schema, this.schemas, this.manager, this.mapper);
            this.wsdlVisitor.getDeferredActions().add(fullyQualifiedName, elementAction);
        } else {
            element.setSchemaTypeName(schemaType.getQName());
            if (schemaType.getQName().equals(ReferenceConstants.WSADDRESSING_TYPE)) {
                element.setNillable(true);
            }
        }
        schemaSequence.getItems().add((XmlSchemaObject)element);
        return element;
    }

    private void addCorbaParam(CorbaTypeImpl corbaType, ModeType mode, String partName, Scope fullyQualifiedName) {
        ParamType param = new ParamType();
        param.setName(partName);
        param.setMode(mode);
        if (corbaType == null) {
            ParamDeferredAction paramAction = new ParamDeferredAction(param);
            this.wsdlVisitor.getDeferredActions().add(fullyQualifiedName, paramAction);
        } else {
            param.setIdltype(corbaType.getQName());
        }
        this.corbaOperation.getParam().add(param);
    }
}

