/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.corba.types;

import javax.xml.namespace.QName;
import org.apache.cxf.binding.corba.CorbaTypeMap;
import org.apache.cxf.binding.corba.types.AbstractCorbaTypeListener;
import org.apache.cxf.binding.corba.types.CorbaHandlerUtils;
import org.apache.cxf.binding.corba.types.CorbaObjectHandler;
import org.apache.cxf.binding.corba.types.CorbaSequenceHandler;
import org.apache.cxf.binding.corba.types.CorbaTypeListener;
import org.apache.cxf.binding.corba.wsdl.Anonsequence;
import org.apache.cxf.binding.corba.wsdl.CorbaTypeImpl;
import org.apache.cxf.binding.corba.wsdl.Sequence;
import org.apache.cxf.service.model.ServiceInfo;
import org.omg.CORBA.ORB;

public class CorbaSequenceListener
extends AbstractCorbaTypeListener {
    private final CorbaSequenceHandler value;
    private final QName seqElementType;
    private final ORB orb;
    private final CorbaTypeMap typeMap;
    private CorbaTypeListener currentTypeListener;
    private ServiceInfo serviceInfo;
    private int depth;

    public CorbaSequenceListener(CorbaObjectHandler handler, CorbaTypeMap map, ORB orbRef, ServiceInfo sInfo) {
        super(handler);
        QName elementName;
        this.value = (CorbaSequenceHandler)handler;
        this.orb = orbRef;
        this.typeMap = map;
        this.serviceInfo = sInfo;
        CorbaTypeImpl seqType = handler.getType();
        if (seqType instanceof Anonsequence) {
            Anonsequence anonSeqType = (Anonsequence)seqType;
            this.seqElementType = anonSeqType.getElemtype();
            elementName = anonSeqType.getElemname();
        } else {
            Sequence type = (Sequence)seqType;
            this.seqElementType = type.getElemtype();
            elementName = type.getElemname();
        }
        CorbaObjectHandler template = CorbaHandlerUtils.initializeObjectHandler(this.orb, elementName, this.seqElementType, this.typeMap, this.serviceInfo);
        this.value.setTemplateElement(template);
    }

    public void processStartElement(QName name) {
        ++this.depth;
        if (this.currentTypeListener == null) {
            this.currentElement = name;
            this.currentTypeListener = CorbaHandlerUtils.getTypeListener(name, this.seqElementType, this.typeMap, this.orb, this.serviceInfo);
            this.value.addElement(this.currentTypeListener.getCorbaObject());
        } else {
            this.currentTypeListener.processStartElement(name);
        }
    }

    public void processEndElement(QName name) {
        if (this.currentTypeListener != null) {
            this.currentTypeListener.processEndElement(name);
            --this.depth;
            if (this.depth == 0 && this.currentElement.equals(name)) {
                this.currentTypeListener = null;
            }
        }
    }

    public void processCharacters(String text) {
        if (this.currentTypeListener == null) {
            CorbaTypeListener primitiveListener = CorbaHandlerUtils.getTypeListener(this.value.getName(), this.seqElementType, this.typeMap, this.orb, this.serviceInfo);
            this.value.addElement(primitiveListener.getCorbaObject());
            primitiveListener.processCharacters(text);
        } else {
            this.currentTypeListener.processCharacters(text);
        }
    }

    public void processWriteAttribute(String prefix, String namespaceURI, String localName, String val) {
        if (this.currentTypeListener != null) {
            this.currentTypeListener.processWriteAttribute(prefix, namespaceURI, localName, val);
        }
    }

    public void processWriteNamespace(String prefix, String namespaceURI) {
        if (this.currentTypeListener != null) {
            this.currentTypeListener.processWriteNamespace(prefix, namespaceURI);
        }
    }
}

