/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.binding.corba.runtime;

import java.util.List;
import java.util.Stack;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.binding.corba.CorbaBindingException;
import org.apache.cxf.binding.corba.CorbaTypeMap;
import org.apache.cxf.binding.corba.types.CorbaHandlerUtils;
import org.apache.cxf.binding.corba.types.CorbaObjectHandler;
import org.apache.cxf.binding.corba.types.CorbaTypeListener;
import org.apache.cxf.binding.corba.wsdl.ArgType;
import org.apache.cxf.service.model.ServiceInfo;
import org.omg.CORBA.ORB;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorbaStreamWriter
implements XMLStreamWriter {
    protected String defaultNS = "";
    protected CorbaTypeListener[] listeners;
    protected ServiceInfo serviceInfo;
    protected CorbaTypeMap typeMap;
    protected ORB orb;
    protected CorbaTypeListener currentTypeListener;
    private List<ArgType> params;
    private int paramCounter;
    private Stack<QName> elements = new Stack();
    private QName paramElement;
    private QName wrapElementName;
    private boolean skipWrap;
    private NamespaceContext ctx;

    public CorbaStreamWriter(ORB orbRef, CorbaTypeMap map, ServiceInfo sinfo) {
        this.orb = orbRef;
        this.typeMap = map;
        this.serviceInfo = sinfo;
    }

    public CorbaStreamWriter(ORB orbRef, List<ArgType> paramTypes, CorbaTypeMap map, ServiceInfo sinfo, boolean wrap) {
        this(orbRef, map, sinfo);
        this.params = paramTypes;
        this.skipWrap = wrap;
        this.listeners = new CorbaTypeListener[paramTypes.size()];
    }

    public CorbaObjectHandler[] getCorbaObjects() {
        CorbaObjectHandler[] handlers = new CorbaObjectHandler[this.listeners.length];
        for (int i = 0; i < this.listeners.length; ++i) {
            if (this.listeners[i] == null) {
                throw new CorbaBindingException("Uninitalized object for parameter " + this.params.get(i).getName());
            }
            handlers[i] = this.listeners[i].getCorbaObject();
        }
        return handlers;
    }

    @Override
    public void writeStartElement(String namespaceURI, String localName) throws XMLStreamException {
        this.writeStartElement("", localName, namespaceURI);
    }

    @Override
    public void writeEndElement() throws XMLStreamException {
        if (this.elements.empty()) {
            this.currentTypeListener = null;
        } else {
            QName name = this.elements.pop();
            if (name.equals(this.paramElement) || name.equals(this.wrapElementName)) {
                this.currentTypeListener = null;
            } else {
                this.currentTypeListener.processEndElement(name);
            }
        }
    }

    @Override
    public void writeStartElement(String localName) throws XMLStreamException {
        this.writeStartElement("", localName, this.defaultNS);
    }

    @Override
    public void writeStartElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        if (prefix != null) {
            this.setPrefix(prefix, namespaceURI);
        }
        QName name = new QName(namespaceURI, localName, prefix);
        this.elements.push(name);
        if (!this.skipWrap) {
            if (this.currentTypeListener == null) {
                this.paramElement = name;
                this.setCurrentTypeListener(name);
            } else {
                this.currentTypeListener.processStartElement(name);
            }
        } else {
            this.wrapElementName = name;
            this.skipWrap = false;
        }
    }

    protected void setCurrentTypeListener(QName name) throws XMLStreamException {
        ArgType param = this.params.get(this.paramCounter);
        QName idlType = param.getIdltype();
        if (!this.skipWrap || name.getLocalPart().equals(param.getName())) {
            this.listeners[this.paramCounter] = this.currentTypeListener = CorbaHandlerUtils.getTypeListener(name, idlType, this.typeMap, this.orb, this.serviceInfo);
            ++this.paramCounter;
        } else {
            throw new XMLStreamException("Expected element not found: " + param.getName() + " (Found " + name.getLocalPart() + ")");
        }
    }

    @Override
    public void writeEmptyElement(String namespaceURI, String localName) throws XMLStreamException {
        this.writeStartElement(namespaceURI, localName);
        this.writeEndElement();
    }

    @Override
    public void writeEmptyElement(String prefix, String localName, String namespaceURI) throws XMLStreamException {
        this.writeStartElement(namespaceURI, localName, prefix);
        this.writeEndElement();
    }

    @Override
    public void writeEmptyElement(String localName) throws XMLStreamException {
        this.writeStartElement(localName);
        this.writeEndElement();
    }

    @Override
    public void writeEndDocument() throws XMLStreamException {
    }

    @Override
    public void close() throws XMLStreamException {
    }

    @Override
    public void flush() throws XMLStreamException {
    }

    @Override
    public void writeAttribute(String localName, String value) throws XMLStreamException {
        this.writeAttribute("", this.defaultNS, localName, value);
    }

    @Override
    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        this.currentTypeListener.processWriteAttribute(prefix, namespaceURI, localName, value);
    }

    @Override
    public void writeAttribute(String namespaceURI, String localName, String value) throws XMLStreamException {
        this.writeAttribute("", namespaceURI, localName, value);
    }

    @Override
    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        if (this.currentTypeListener != null) {
            this.currentTypeListener.processWriteNamespace(prefix, namespaceURI);
        }
        this.setPrefix(prefix, namespaceURI);
    }

    @Override
    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
        this.defaultNS = namespaceURI;
    }

    @Override
    public void writeComment(String data) throws XMLStreamException {
    }

    @Override
    public void writeProcessingInstruction(String target) throws XMLStreamException {
    }

    @Override
    public void writeProcessingInstruction(String target, String data) throws XMLStreamException {
    }

    @Override
    public void writeCData(String data) throws XMLStreamException {
        throw new XMLStreamException("Not yet implemented");
    }

    @Override
    public void writeDTD(String dtd) throws XMLStreamException {
    }

    @Override
    public void writeEntityRef(String name) throws XMLStreamException {
        throw new XMLStreamException("Not yet implemented");
    }

    @Override
    public void writeStartDocument() throws XMLStreamException {
    }

    @Override
    public void writeStartDocument(String encoding, String version) throws XMLStreamException {
    }

    @Override
    public void writeStartDocument(String version) throws XMLStreamException {
    }

    @Override
    public void writeCharacters(String text) throws XMLStreamException {
        this.currentTypeListener.processCharacters(text);
    }

    @Override
    public void writeCharacters(char[] text, int start, int len) throws XMLStreamException {
        this.currentTypeListener.processCharacters(new String(text));
    }

    @Override
    public String getPrefix(String uri) throws XMLStreamException {
        return null;
    }

    @Override
    public void setPrefix(String prefix, String uri) throws XMLStreamException {
    }

    @Override
    public void setDefaultNamespace(String uri) throws XMLStreamException {
        this.defaultNS = uri;
    }

    @Override
    public void setNamespaceContext(NamespaceContext context) throws XMLStreamException {
        this.ctx = context;
    }

    @Override
    public NamespaceContext getNamespaceContext() {
        return this.ctx;
    }

    @Override
    public Object getProperty(String name) throws IllegalArgumentException {
        return null;
    }
}

