/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.utils;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Set;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.ws.rs.ConsumeMime;
import javax.ws.rs.CookieParam;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.Encoded;
import javax.ws.rs.HeaderParam;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.MatrixParam;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.ProduceMime;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.SecurityContext;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.MessageBodyWorkers;
import org.apache.cxf.jaxrs.ext.MessageContext;
import org.apache.cxf.jaxrs.model.OperationResourceInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotationUtils {
    private static final Set<Class> CONTEXT_CLASSES = AnnotationUtils.initContextClasses();
    private static final Set<Class> PARAM_ANNOTATION_CLASSES = AnnotationUtils.initParamAnnotationClasses();
    private static final Set<Class> METHOD_ANNOTATION_CLASSES = AnnotationUtils.initMethodAnnotationClasses();

    private AnnotationUtils() {
    }

    private static Set<Class> initContextClasses() {
        HashSet<Class> classes = new HashSet<Class>();
        classes.add(UriInfo.class);
        classes.add(SecurityContext.class);
        classes.add(HttpHeaders.class);
        classes.add(ContextResolver.class);
        classes.add(MessageBodyWorkers.class);
        classes.add(Request.class);
        classes.add(HttpServletRequest.class);
        classes.add(HttpServletResponse.class);
        classes.add(ServletConfig.class);
        classes.add(ServletContext.class);
        classes.add(MessageContext.class);
        return classes;
    }

    private static Set<Class> initParamAnnotationClasses() {
        HashSet<Class> classes = new HashSet<Class>();
        classes.add(PathParam.class);
        classes.add(QueryParam.class);
        classes.add(MatrixParam.class);
        classes.add(HeaderParam.class);
        classes.add(CookieParam.class);
        return classes;
    }

    private static Set<Class> initMethodAnnotationClasses() {
        HashSet<Class> classes = new HashSet<Class>();
        classes.add(HttpMethod.class);
        classes.add(Path.class);
        classes.add(ProduceMime.class);
        classes.add(ConsumeMime.class);
        return classes;
    }

    public static boolean isContextClass(Class<?> contextClass) {
        return CONTEXT_CLASSES.contains(contextClass);
    }

    public static boolean isParamAnnotationClass(Class<?> annotationClass) {
        return PARAM_ANNOTATION_CLASSES.contains(annotationClass);
    }

    public static boolean isMethodParamAnnotationClass(Class<?> annotationClass) {
        return PARAM_ANNOTATION_CLASSES.contains(annotationClass) || Context.class == annotationClass;
    }

    public static boolean isMethodParamAnnotations(Annotation[] paramAnnotations) {
        for (Annotation a : paramAnnotations) {
            if (!AnnotationUtils.isMethodParamAnnotationClass(a.annotationType())) continue;
            return true;
        }
        return false;
    }

    public static boolean isMethodAnnotation(Annotation a) {
        return METHOD_ANNOTATION_CLASSES.contains(a.annotationType()) || a.annotationType().getAnnotation(HttpMethod.class) != null;
    }

    public static String getAnnotationValue(Annotation a) {
        if (a.annotationType() == PathParam.class) {
            return ((PathParam)a).value();
        }
        if (a.annotationType() == QueryParam.class) {
            return ((QueryParam)a).value();
        }
        if (a.annotationType() == MatrixParam.class) {
            return ((MatrixParam)a).value();
        }
        if (a.annotationType() == HeaderParam.class) {
            return ((HeaderParam)a).value();
        }
        if (a.annotationType() == CookieParam.class) {
            return ((CookieParam)a).value();
        }
        return null;
    }

    public static <T> T getAnnotation(Annotation[] anns, Class<T> type) {
        if (anns == null) {
            return null;
        }
        for (Annotation a : anns) {
            if (a.annotationType() != type) continue;
            return (T)a;
        }
        return null;
    }

    public static Method getAnnotatedMethod(Method m) {
        Method annotatedMethod = AnnotationUtils.doGetAnnotatedMethod(m);
        return annotatedMethod == null ? m : annotatedMethod;
    }

    /*
     * WARNING - void declaration
     */
    private static Method doGetAnnotatedMethod(Method m) {
        void var4_11;
        if (m == null) {
            return m;
        }
        for (Annotation annotation : m.getAnnotations()) {
            if (!AnnotationUtils.isMethodAnnotation(annotation)) continue;
            return m;
        }
        for (Annotation annotation : m.getParameterAnnotations()) {
            if (!AnnotationUtils.isMethodParamAnnotations((Annotation[])annotation)) continue;
            return m;
        }
        Class<?> superC = m.getDeclaringClass().getSuperclass();
        if (superC != null && Object.class != superC) {
            try {
                Method method = AnnotationUtils.doGetAnnotatedMethod(superC.getMethod(m.getName(), m.getParameterTypes()));
                if (method != null) {
                    return method;
                }
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
        }
        Class<?>[] arr$ = m.getDeclaringClass().getInterfaces();
        int len$ = arr$.length;
        boolean bl = false;
        while (var4_11 < len$) {
            Class<?> i = arr$[var4_11];
            try {
                Method method = AnnotationUtils.doGetAnnotatedMethod(i.getMethod(m.getName(), m.getParameterTypes()));
                if (method != null) {
                    return method;
                }
            }
            catch (NoSuchMethodException ex) {
                // empty catch block
            }
            ++var4_11;
        }
        return null;
    }

    public static String getHttpMethodValue(Method m) {
        for (Annotation a : m.getAnnotations()) {
            HttpMethod httpM = a.annotationType().getAnnotation(HttpMethod.class);
            if (httpM == null) continue;
            return httpM.value();
        }
        return null;
    }

    public static Annotation getMethodAnnotation(Method m, Class<? extends Annotation> aClass) {
        return m == null ? null : m.getAnnotation(aClass);
    }

    public static Annotation getClassAnnotation(Class<?> c, Class<? extends Annotation> aClass) {
        if (c == null) {
            return null;
        }
        Annotation p = c.getAnnotation(aClass);
        if (p != null) {
            return p;
        }
        p = AnnotationUtils.getClassAnnotation(c.getSuperclass(), aClass);
        if (p != null) {
            return p;
        }
        for (Class<?> i : c.getInterfaces()) {
            p = AnnotationUtils.getClassAnnotation(i, aClass);
            if (p == null) continue;
            return p;
        }
        return null;
    }

    public static boolean isEncoded(Annotation[] anns, OperationResourceInfo ori) {
        if (AnnotationUtils.getAnnotation(anns, Encoded.class) != null) {
            return true;
        }
        if (ori == null) {
            return false;
        }
        return ori.isEncodedEnabled();
    }

    public static String getDefaultParameterValue(Annotation[] anns, OperationResourceInfo ori) {
        DefaultValue dv = AnnotationUtils.getAnnotation(anns, DefaultValue.class);
        if (dv != null) {
            return dv.value();
        }
        if (ori == null) {
            return null;
        }
        return ori.getDefaultParameterValue();
    }
}

