/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.type.java5;

import org.apache.cxf.aegis.Context;
import org.apache.cxf.aegis.DatabindingException;
import org.apache.cxf.aegis.type.Type;
import org.apache.cxf.aegis.xml.MessageReader;
import org.apache.cxf.aegis.xml.MessageWriter;
import org.jdom.Attribute;
import org.jdom.Content;
import org.jdom.Element;
import org.jdom.Namespace;

public class EnumType
extends Type {
    public Object readObject(MessageReader reader, Context context) {
        String value = reader.getValue();
        return Enum.valueOf(this.getTypeClass(), value.trim());
    }

    public void writeObject(Object object, MessageWriter writer, Context context) {
        writer.writeValue(((Enum)object).name());
    }

    public void setTypeClass(Class typeClass) {
        if (!typeClass.isEnum()) {
            throw new DatabindingException("Type class must be an enum.");
        }
        super.setTypeClass(typeClass);
    }

    public void writeSchema(Element root) {
        T[] constants;
        Namespace xsd = Namespace.getNamespace((String)"xsd", (String)"http://www.w3.org/2001/XMLSchema");
        Element simple = new Element("simpleType", xsd);
        simple.setAttribute(new Attribute("name", this.getSchemaType().getLocalPart()));
        root.addContent((Content)simple);
        Element restriction = new Element("restriction", xsd);
        restriction.setAttribute(new Attribute("base", "xsd:string"));
        simple.addContent((Content)restriction);
        for (Object constant : constants = this.getTypeClass().getEnumConstants()) {
            Element enumeration = new Element("enumeration", xsd);
            enumeration.setAttribute(new Attribute("value", ((Enum)constant).name()));
            restriction.addContent((Content)enumeration);
        }
    }

    public boolean isComplex() {
        return true;
    }
}

