/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import org.apache.cxf.aegis.AegisContext;
import org.apache.cxf.common.logging.LogUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAegisProvider
implements MessageBodyReader<Object>,
MessageBodyWriter<Object> {
    private static final Logger LOG = LogUtils.getL7dLogger(AbstractAegisProvider.class);
    private static final String CLASSPATH_PREFIX = "classpath:";
    private static Map<Class<?>, AegisContext> classContexts = new WeakHashMap();
    @Context
    protected ContextResolver<AegisContext> resolver;
    private Schema schema;

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] anns) {
        return this.isSupported(type, genericType, anns);
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations) {
        return this.isSupported(type, genericType, annotations);
    }

    public void setSchemas(List<String> locations) {
        this.schema = this.createSchema(locations);
    }

    public long getSize(Object o) {
        return -1L;
    }

    protected AegisContext getAegisContext(Class<?> type, Type genericType) {
        AegisContext context;
        if (this.resolver != null && (context = (AegisContext)this.resolver.getContext(type)) != null) {
            return context;
        }
        return this.getClassContext(type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AegisContext getClassContext(Class<?> type) {
        Map<Class<?>, AegisContext> map = classContexts;
        synchronized (map) {
            AegisContext context = classContexts.get(type);
            if (context == null) {
                context = new AegisContext();
                HashSet rootClasses = new HashSet();
                context.setRootClasses(rootClasses);
                context.initialize();
                classContexts.put(type, context);
            }
            return context;
        }
    }

    protected boolean isSupported(Class<?> type, Type genericType, Annotation[] annotations) {
        return true;
    }

    private Schema createSchema(List<String> locations) {
        SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        Schema s = null;
        try {
            ArrayList<StreamSource> sources = new ArrayList<StreamSource>();
            for (String loc : locations) {
                InputStream is = null;
                if (loc.startsWith(CLASSPATH_PREFIX)) {
                    String path = loc.substring(CLASSPATH_PREFIX.length() + 1);
                    is = this.getClass().getClassLoader().getResourceAsStream(path);
                    if (is == null) {
                        LOG.warning("No schema resource " + loc + " is available on classpath");
                        return null;
                    }
                } else {
                    File f = new File(loc);
                    if (!f.exists()) {
                        LOG.warning("No schema resource " + loc + " is available on local disk");
                        return null;
                    }
                    is = new FileInputStream(f);
                }
                BufferedReader r = new BufferedReader(new InputStreamReader(is, "UTF-8"));
                sources.add(new StreamSource(r));
            }
            s = factory.newSchema(sources.toArray(new Source[0]));
        }
        catch (Exception ex) {
            LOG.warning("Validation will be disabled, failed to create schema : " + ex.getMessage());
        }
        return s;
    }

    protected Schema getSchema() {
        return this.schema;
    }
}

