/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.builders;

import java.util.Arrays;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.ws.policy.AssertionBuilder;
import org.apache.cxf.ws.policy.PolicyAssertion;
import org.apache.cxf.ws.policy.PolicyBuilder;
import org.apache.cxf.ws.security.policy.SP11Constants;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.SecureConversationToken;
import org.apache.neethi.Policy;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecureConversationTokenBuilder
implements AssertionBuilder {
    private static final List<QName> KNOWN_ELEMENTS = Arrays.asList(SP11Constants.SECURE_CONVERSATION_TOKEN, SP12Constants.SECURE_CONVERSATION_TOKEN);
    PolicyBuilder builder;

    public SecureConversationTokenBuilder(PolicyBuilder b) {
        this.builder = b;
    }

    public List<QName> getKnownElements() {
        return KNOWN_ELEMENTS;
    }

    @Override
    public PolicyAssertion build(Element element) throws IllegalArgumentException {
        SPConstants consts = "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy".equals(element.getNamespaceURI()) ? SP11Constants.INSTANCE : SP12Constants.INSTANCE;
        SecureConversationToken conversationToken = new SecureConversationToken(consts);
        String attribute = DOMUtils.getAttribute(element, consts.getIncludeToken());
        if (attribute == null) {
            throw new IllegalArgumentException("SecurityContextToken doesn't contain any sp:IncludeToken attribute");
        }
        String inclusionValue = attribute.trim();
        conversationToken.setInclusion(consts.getInclusionFromAttributeValue(inclusionValue));
        Element issuer = DOMUtils.getFirstChildWithName(element, consts.getNamespace(), "Issuer");
        if (issuer != null) {
            conversationToken.setIssuerEpr(DOMUtils.getFirstElement(issuer));
        }
        if ((element = DOMUtils.getFirstChildWithName(element, SPConstants.POLICY)) != null) {
            Element bootstrapPolicyElement;
            if (DOMUtils.getFirstChildWithName(element, consts.getNamespace(), "RequireDerivedKeys") != null) {
                conversationToken.setDerivedKeys(true);
            } else if (DOMUtils.getFirstChildWithName(element, SP12Constants.REQUIRE_IMPLIED_DERIVED_KEYS) != null) {
                conversationToken.setImpliedDerivedKeys(true);
            } else if (DOMUtils.getFirstChildWithName(element, SP12Constants.REQUIRE_EXPLICIT_DERIVED_KEYS) != null) {
                conversationToken.setExplicitDerivedKeys(true);
            }
            if (DOMUtils.getFirstChildWithName(element, consts.getNamespace(), "RequireExternalUriReference") != null) {
                conversationToken.setRequireExternalUriRef(true);
            }
            if (DOMUtils.getFirstChildWithName(element, consts.getNamespace(), "SC10SecurityContextToken") != null) {
                conversationToken.setSc10SecurityContextToken(true);
            }
            if ((bootstrapPolicyElement = DOMUtils.getFirstChildWithName(element, consts.getNamespace(), "BootstrapPolicy")) != null) {
                Policy policy = this.builder.getPolicy(DOMUtils.getFirstElement(bootstrapPolicyElement));
                conversationToken.setBootstrapPolicy(policy);
            }
        }
        return conversationToken;
    }

    @Override
    public PolicyAssertion buildCompatible(PolicyAssertion a, PolicyAssertion b) {
        return null;
    }
}

