/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.addressing;

import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.Result;
import javax.xml.transform.dom.DOMResult;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import org.apache.cxf.common.util.PackageUtils;
import org.apache.cxf.helpers.XMLUtils;
import org.apache.cxf.staxutils.W3CDOMStreamReader;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.ContextUtils;
import org.apache.cxf.ws.addressing.ObjectFactory;
import org.apache.cxf.ws.addressing.RelatesToType;
import org.apache.cxf.ws.addressing.v200408.AttributedQName;
import org.apache.cxf.ws.addressing.v200408.AttributedURI;
import org.apache.cxf.ws.addressing.v200408.EndpointReferenceType;
import org.apache.cxf.ws.addressing.v200408.ReferenceParametersType;
import org.apache.cxf.ws.addressing.v200408.Relationship;
import org.apache.cxf.ws.addressing.v200408.ServiceNameType;
import org.apache.cxf.wsdl.EndpointReferenceUtils;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionTransformer {
    protected static final String NATIVE_VERSION = "http://www.w3.org/2005/08/addressing";

    public boolean isSupported(String namespace) {
        return NATIVE_VERSION.equals(namespace) || "http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(namespace);
    }

    public static AttributedURI convert(AttributedURIType internal) {
        AttributedURI exposed = Names200408.WSA_OBJECT_FACTORY.createAttributedURI();
        String exposedValue = "http://www.w3.org/2005/08/addressing/anonymous".equals(internal.getValue()) ? "http://schemas.xmlsoap.org/ws/2004/08/addressing/role/anonymous" : ("http://www.w3.org/2005/08/addressing/none".equals(internal.getValue()) ? "http://schemas.xmlsoap.org/ws/2004/08/addressing/role/none" : internal.getValue());
        exposed.setValue(exposedValue);
        VersionTransformer.putAll(exposed.getOtherAttributes(), internal.getOtherAttributes());
        return exposed;
    }

    public static AttributedURIType convert(AttributedURI exposed) {
        AttributedURIType internal = ContextUtils.WSA_OBJECT_FACTORY.createAttributedURIType();
        String internalValue = "http://schemas.xmlsoap.org/ws/2004/08/addressing/role/anonymous".equals(exposed.getValue()) ? "http://www.w3.org/2005/08/addressing/anonymous" : ("http://schemas.xmlsoap.org/ws/2004/08/addressing/role/none".equals(exposed.getValue()) ? "http://www.w3.org/2005/08/addressing/none" : exposed.getValue());
        internal.setValue(internalValue);
        VersionTransformer.putAll(internal.getOtherAttributes(), exposed.getOtherAttributes());
        return internal;
    }

    public static EndpointReferenceType convert(org.apache.cxf.ws.addressing.EndpointReferenceType internal) {
        String portLocalName;
        EndpointReferenceType exposed = Names200408.WSA_OBJECT_FACTORY.createEndpointReferenceType();
        exposed.setAddress(VersionTransformer.convert(internal.getAddress()));
        exposed.setReferenceParameters(VersionTransformer.convert(internal.getReferenceParameters()));
        QName serviceQName = EndpointReferenceUtils.getServiceName(internal, null);
        if (serviceQName != null) {
            ServiceNameType serviceName = Names200408.WSA_OBJECT_FACTORY.createServiceNameType();
            serviceName.setValue(serviceQName);
            exposed.setServiceName(serviceName);
        }
        if ((portLocalName = EndpointReferenceUtils.getPortName(internal)) != null) {
            String namespace = serviceQName.getNamespaceURI() != null ? serviceQName.getNamespaceURI() : "http://www.w3.org/2004/08/wsdl-instance";
            QName portQName = new QName(namespace, portLocalName);
            AttributedQName portType = Names200408.WSA_OBJECT_FACTORY.createAttributedQName();
            portType.setValue(portQName);
            exposed.setPortType(portType);
        }
        VersionTransformer.addAll(exposed.getAny(), internal.getAny());
        VersionTransformer.putAll(exposed.getOtherAttributes(), internal.getOtherAttributes());
        return exposed;
    }

    public static org.apache.cxf.ws.addressing.EndpointReferenceType convert(EndpointReferenceType exposed) {
        org.apache.cxf.ws.addressing.EndpointReferenceType internal = ContextUtils.WSA_OBJECT_FACTORY.createEndpointReferenceType();
        internal.setAddress(VersionTransformer.convert(exposed.getAddress()));
        internal.setReferenceParameters(VersionTransformer.convert(exposed.getReferenceParameters()));
        ServiceNameType serviceName = exposed.getServiceName();
        AttributedQName portName = exposed.getPortType();
        if (serviceName != null && portName != null) {
            EndpointReferenceUtils.setServiceAndPortName(internal, serviceName.getValue(), portName.getValue().getLocalPart());
        }
        VersionTransformer.addAll(internal.getAny(), exposed.getAny());
        VersionTransformer.putAll(internal.getOtherAttributes(), exposed.getOtherAttributes());
        return internal;
    }

    public static org.apache.cxf.ws.addressing.EndpointReferenceType convertToInternal(EndpointReference external) {
        if (external instanceof W3CEndpointReference) {
            try {
                Document doc = XMLUtils.newDocument();
                DOMResult result = new DOMResult(doc);
                external.writeTo((Result)result);
                W3CDOMStreamReader reader = new W3CDOMStreamReader(doc.getDocumentElement());
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
                org.apache.cxf.ws.addressing.EndpointReferenceType internal = (org.apache.cxf.ws.addressing.EndpointReferenceType)jaxbContext.createUnmarshaller().unmarshal((XMLStreamReader)reader, org.apache.cxf.ws.addressing.EndpointReferenceType.class).getValue();
                return internal;
            }
            catch (JAXBException e) {
                e.printStackTrace();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            return null;
        }
        return null;
    }

    public static ReferenceParametersType convert(org.apache.cxf.ws.addressing.ReferenceParametersType internal) {
        ReferenceParametersType exposed = null;
        if (internal != null) {
            exposed = Names200408.WSA_OBJECT_FACTORY.createReferenceParametersType();
            VersionTransformer.addAll(exposed.getAny(), internal.getAny());
        }
        return exposed;
    }

    public static org.apache.cxf.ws.addressing.ReferenceParametersType convert(ReferenceParametersType exposed) {
        org.apache.cxf.ws.addressing.ReferenceParametersType internal = null;
        if (exposed != null) {
            internal = ContextUtils.WSA_OBJECT_FACTORY.createReferenceParametersType();
            VersionTransformer.addAll(internal.getAny(), exposed.getAny());
        }
        return internal;
    }

    public static Relationship convert(RelatesToType internal) {
        Relationship exposed = null;
        if (internal != null) {
            exposed = Names200408.WSA_OBJECT_FACTORY.createRelationship();
            exposed.setValue(internal.getValue());
            String internalRelationshipType = internal.getRelationshipType();
            if (internalRelationshipType != null) {
                QName exposedRelationshipType = null;
                if (!"http://www.w3.org/2005/08/addressing/reply".equals(internalRelationshipType)) {
                    exposedRelationshipType = new QName(internalRelationshipType);
                }
                exposed.setRelationshipType(exposedRelationshipType);
            }
            VersionTransformer.putAll(exposed.getOtherAttributes(), internal.getOtherAttributes());
        }
        return exposed;
    }

    public static RelatesToType convert(Relationship exposed) {
        RelatesToType internal = null;
        if (exposed != null) {
            internal = ContextUtils.WSA_OBJECT_FACTORY.createRelatesToType();
            internal.setValue(exposed.getValue());
            QName exposedRelationshipType = exposed.getRelationshipType();
            if (exposedRelationshipType != null) {
                String internalRelationshipType = "reply".equals(exposedRelationshipType.getLocalPart()) ? "http://www.w3.org/2005/08/addressing/reply" : exposedRelationshipType.toString();
                internal.setRelationshipType(internalRelationshipType);
            }
            internal.getOtherAttributes().putAll(exposed.getOtherAttributes());
        }
        return internal;
    }

    public static JAXBContext getExposedJAXBContext(String exposedURI) throws JAXBException {
        return NATIVE_VERSION.equals(exposedURI) ? ContextUtils.getJAXBContext() : Names200408.getJAXBContext();
    }

    private static void putAll(Map<QName, String> to, Map<QName, String> from) {
        if (from != null) {
            to.putAll(from);
        }
    }

    private static void addAll(List<Object> to, List<Object> from) {
        if (from != null) {
            to.addAll(from);
        }
    }

    public static class Names200408 {
        public static final String WSA_NAMESPACE_NAME = "http://schemas.xmlsoap.org/ws/2004/08/addressing";
        public static final String WSA_ANONYMOUS_ADDRESS = "http://schemas.xmlsoap.org/ws/2004/08/addressing/role/anonymous";
        public static final String WSA_NONE_ADDRESS = "http://schemas.xmlsoap.org/ws/2004/08/addressing/role/none";
        public static final org.apache.cxf.ws.addressing.v200408.ObjectFactory WSA_OBJECT_FACTORY = new org.apache.cxf.ws.addressing.v200408.ObjectFactory();
        public static final Class<EndpointReferenceType> EPR_TYPE = EndpointReferenceType.class;
        private static JAXBContext jaxbContext;

        protected Names200408() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static JAXBContext getJAXBContext() throws JAXBException {
            Class<Names200408> clazz = Names200408.class;
            synchronized (Names200408.class) {
                if (jaxbContext == null) {
                    Class<org.apache.cxf.ws.addressing.v200408.ObjectFactory> clz = org.apache.cxf.ws.addressing.v200408.ObjectFactory.class;
                    jaxbContext = JAXBContext.newInstance((String)PackageUtils.getPackageName(clz), (ClassLoader)clz.getClassLoader());
                }
                // ** MonitorExit[var0] (shouldn't be in output)
                return jaxbContext;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void setJAXBContext(JAXBContext ctx) throws JAXBException {
            Class<Names200408> clazz = Names200408.class;
            synchronized (Names200408.class) {
                jaxbContext = ctx;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return;
            }
        }
    }
}

