/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.corba.common.idltypes;

import org.apache.cxf.tools.corba.common.idltypes.IdlScopeBase;

public class IdlScopedName {
    private String fullName;
    private String localName;
    private String[] parentNames;

    IdlScopedName(IdlScopeBase parent, String name) {
        if (parent != null) {
            this.fullName = new String(parent.fullName() + "::" + name);
            this.parentNames = parent.name().parentNames();
        } else {
            this.fullName = new String(name);
            this.parentNames = null;
        }
        this.localName = new String(name);
    }

    String localName() {
        return this.localName;
    }

    String fullName() {
        return this.fullName;
    }

    String fullName(IdlScopedName relativeTo) {
        if (relativeTo == null) {
            return this.fullName();
        }
        StringBuffer nm = new StringBuffer(this.fullName);
        String rel = relativeTo.fullName() + "::";
        if (this.fullName.indexOf(rel) == 0) {
            nm.delete(0, rel.length());
        }
        return nm.toString();
    }

    String[] parentNames() {
        return this.parentNames;
    }
}

