/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.security.policy.builders;

import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.apache.cxf.helpers.DOMUtils;
import org.apache.cxf.ws.policy.AssertionBuilder;
import org.apache.cxf.ws.policy.PolicyAssertion;
import org.apache.cxf.ws.policy.PolicyBuilder;
import org.apache.cxf.ws.security.policy.SP11Constants;
import org.apache.cxf.ws.security.policy.SP12Constants;
import org.apache.cxf.ws.security.policy.SPConstants;
import org.apache.cxf.ws.security.policy.model.Wss10;
import org.apache.neethi.Assertion;
import org.apache.neethi.Policy;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WSS10Builder
implements AssertionBuilder {
    private static final List<QName> KNOWN_ELEMENTS = Arrays.asList(SP11Constants.WSS10, SP12Constants.WSS10);
    PolicyBuilder builder;

    public WSS10Builder(PolicyBuilder b) {
        this.builder = b;
    }

    public List<QName> getKnownElements() {
        return KNOWN_ELEMENTS;
    }

    @Override
    public PolicyAssertion build(Element element) throws IllegalArgumentException {
        SPConstants consts = "http://schemas.xmlsoap.org/ws/2005/07/securitypolicy".equals(element.getNamespaceURI()) ? SP11Constants.INSTANCE : SP12Constants.INSTANCE;
        Wss10 wss10 = new Wss10(consts);
        Policy policy = this.builder.getPolicy(DOMUtils.getFirstElement(element));
        Iterator iterator = (policy = (Policy)policy.normalize(false)).getAlternatives();
        if (iterator.hasNext()) {
            this.processAlternative((List)iterator.next(), wss10, consts);
        }
        return wss10;
    }

    private void processAlternative(List assertions, Wss10 parent, SPConstants consts) {
        for (Assertion assertion : assertions) {
            QName name = assertion.getName();
            if (!consts.getNamespace().equals(name.getNamespaceURI())) continue;
            if ("MustSupportRefKeyIdentifier".equals(name.getLocalPart())) {
                parent.setMustSupportRefKeyIdentifier(true);
                continue;
            }
            if ("MustSupportRefIssuerSerial".equals(name.getLocalPart())) {
                parent.setMustSupportRefIssuerSerial(true);
                continue;
            }
            if ("MustSupportRefExternalURI".equals(name.getLocalPart())) {
                parent.setMustSupportRefExternalURI(true);
                continue;
            }
            if (!"MustSupportRefEmbeddedToken".equals(name.getLocalPart())) continue;
            parent.setMustSupportRefEmbeddedToken(true);
        }
    }

    @Override
    public PolicyAssertion buildCompatible(PolicyAssertion a, PolicyAssertion b) {
        return null;
    }
}

