/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.aegis.util.jdom;

import java.io.InputStream;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.staxutils.StaxUtils;
import org.jdom.Attribute;
import org.jdom.CDATA;
import org.jdom.Content;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMFactory;
import org.jdom.Namespace;
import org.jdom.Parent;
import org.jdom.UncheckedJDOMFactory;

public class StaxBuilder {
    private static final Map<String, Integer> ATTR_TYPES = new HashMap<String, Integer>(32);
    protected boolean cfgIgnoreWS;
    private JDOMFactory factory;
    private XMLInputFactory xifactory;
    private Map additionalNamespaces;
    private boolean isReadingMidStream;

    public StaxBuilder() {
        this.xifactory = StaxUtils.getXMLInputFactory();
    }

    public StaxBuilder(Map namespaces) {
        this.xifactory = StaxUtils.getXMLInputFactory();
        this.additionalNamespaces = namespaces;
    }

    public StaxBuilder(XMLInputFactory xifactory) {
        this.xifactory = xifactory;
    }

    public Map getAdditionalNamespaces() {
        return this.additionalNamespaces;
    }

    public void setAdditionalNamespaces(Map additionalNamespaces) {
        this.additionalNamespaces = additionalNamespaces;
    }

    public void setFactory(JDOMFactory f) {
        this.factory = f;
    }

    public void setIgnoreWhitespace(boolean state) {
        this.cfgIgnoreWS = state;
    }

    public JDOMFactory getFactory() {
        return this.factory;
    }

    public Document build(XMLStreamReader r) throws XMLStreamException {
        this.isReadingMidStream = true;
        return this.buildInternal(r);
    }

    public Document build(InputStream is) throws XMLStreamException {
        this.isReadingMidStream = false;
        return this.buildInternal(this.xifactory.createXMLStreamReader(is));
    }

    public Document build(Reader reader) throws XMLStreamException {
        this.isReadingMidStream = false;
        return this.buildInternal(this.xifactory.createXMLStreamReader(reader));
    }

    private Document buildInternal(XMLStreamReader r) throws XMLStreamException {
        JDOMFactory f = this.factory;
        if (f == null) {
            f = new UncheckedJDOMFactory();
        }
        Document doc = f.document(null);
        this.buildTree(f, r, doc);
        return doc;
    }

    private void buildTree(JDOMFactory f, XMLStreamReader r, Document doc) throws XMLStreamException {
        Element current = null;
        int event = r.getEventType();
        if (event == -1) {
            event = r.next();
        }
        while (true) {
            boolean noadd = false;
            CDATA child = null;
            switch (event) {
                case 12: {
                    child = f.cdata(r.getText());
                    break;
                }
                case 6: {
                    if (this.cfgIgnoreWS) {
                        noadd = true;
                        break;
                    }
                }
                case 4: {
                    if (current == null) {
                        noadd = true;
                        break;
                    }
                    child = f.text(r.getText());
                    break;
                }
                case 5: {
                    child = f.comment(r.getText());
                    break;
                }
                case 8: {
                    return;
                }
                case 2: {
                    if (current != null) {
                        current = current.getParentElement();
                    }
                    noadd = true;
                    if (!this.isReadingMidStream || current != null) break;
                    return;
                }
                case 14: 
                case 15: {
                    noadd = true;
                    break;
                }
                case 9: {
                    child = f.entityRef(r.getLocalName());
                    break;
                }
                case 3: {
                    child = f.processingInstruction(r.getPITarget(), r.getPIData());
                    break;
                }
                case 1: {
                    Namespace ns;
                    String prefix;
                    int i;
                    Element newElem = null;
                    String nsURI = r.getNamespaceURI();
                    String elemPrefix = r.getPrefix();
                    String ln = r.getLocalName();
                    newElem = nsURI == null || nsURI.length() == 0 ? (elemPrefix == null || elemPrefix.length() == 0 ? f.element(ln) : f.element(ln, elemPrefix, "")) : f.element(ln, elemPrefix, nsURI);
                    if (current == null) {
                        doc.setRootElement(newElem);
                        if (this.additionalNamespaces != null) {
                            for (String prefix2 : this.additionalNamespaces.keySet()) {
                                String uri = (String)this.additionalNamespaces.get(prefix2);
                                newElem.addNamespaceDeclaration(Namespace.getNamespace((String)prefix2, (String)uri));
                            }
                        }
                    } else {
                        f.addContent((Parent)current, (Content)newElem);
                    }
                    int len = r.getNamespaceCount();
                    for (i = 0; i < len; ++i) {
                        prefix = r.getNamespacePrefix(i);
                        ns = Namespace.getNamespace((String)prefix, (String)r.getNamespaceURI(i));
                        if (prefix != null && prefix.equals(elemPrefix)) continue;
                        f.addNamespaceDeclaration(newElem, ns);
                    }
                    len = r.getAttributeCount();
                    for (i = 0; i < len; ++i) {
                        prefix = r.getAttributePrefix(i);
                        ns = prefix == null || prefix.length() == 0 ? Namespace.NO_NAMESPACE : newElem.getNamespace(prefix);
                        Attribute attr = f.attribute(r.getAttributeLocalName(i), r.getAttributeValue(i), StaxBuilder.resolveAttrType(r.getAttributeType(i)), ns);
                        f.setAttribute(newElem, attr);
                    }
                    current = newElem;
                    noadd = true;
                    break;
                }
            }
            if (!noadd && child != null) {
                if (current == null) {
                    f.addContent((Parent)doc, (Content)child);
                } else {
                    f.addContent((Parent)current, (Content)child);
                }
            }
            if (!r.hasNext()) break;
            event = r.next();
        }
    }

    private static int resolveAttrType(String typeStr) {
        Integer i;
        if (typeStr != null && typeStr.length() > 0 && (i = ATTR_TYPES.get(typeStr)) != null) {
            return i;
        }
        return 0;
    }

    static {
        ATTR_TYPES.put("CDATA", new Integer(1));
        ATTR_TYPES.put("cdata", new Integer(1));
        ATTR_TYPES.put("ID", new Integer(2));
        ATTR_TYPES.put("id", new Integer(2));
        ATTR_TYPES.put("IDREF", new Integer(3));
        ATTR_TYPES.put("idref", new Integer(3));
        ATTR_TYPES.put("IDREFS", new Integer(4));
        ATTR_TYPES.put("idrefs", new Integer(4));
        ATTR_TYPES.put("ENTITY", new Integer(5));
        ATTR_TYPES.put("entity", new Integer(5));
        ATTR_TYPES.put("ENTITIES", new Integer(6));
        ATTR_TYPES.put("entities", new Integer(6));
        ATTR_TYPES.put("NMTOKEN", new Integer(7));
        ATTR_TYPES.put("nmtoken", new Integer(7));
        ATTR_TYPES.put("NMTOKENS", new Integer(8));
        ATTR_TYPES.put("nmtokens", new Integer(8));
        ATTR_TYPES.put("NOTATION", new Integer(9));
        ATTR_TYPES.put("notation", new Integer(9));
        ATTR_TYPES.put("ENUMERATED", new Integer(10));
        ATTR_TYPES.put("enumerated", new Integer(10));
    }
}

