/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.java2wsdl;

import java.util.HashSet;
import org.apache.cxf.common.i18n.Message;
import org.apache.cxf.tools.common.AbstractCXFToolContainer;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.common.ToolException;
import org.apache.cxf.tools.common.toolspec.ToolSpec;
import org.apache.cxf.tools.common.toolspec.parser.BadUsageException;
import org.apache.cxf.tools.common.toolspec.parser.ErrorVisitor;
import org.apache.cxf.tools.java2wsdl.processor.JavaToProcessor;
import org.apache.cxf.tools.util.AnnotationUtil;

public class JavaToWSDLContainer
extends AbstractCXFToolContainer {
    private static final String TOOL_NAME = "java2wsdl";

    public JavaToWSDLContainer(ToolSpec toolspec) throws Exception {
        super(TOOL_NAME, toolspec);
    }

    public void execute(boolean exitOnFinish) throws ToolException {
        JavaToProcessor processor = null;
        try {
            super.execute(exitOnFinish);
            if (!this.hasInfoOption()) {
                ToolContext env = new ToolContext();
                env.setParameters(this.getParametersMap(new HashSet()));
                if (this.isVerboseOn()) {
                    env.put("verbose", Boolean.TRUE);
                }
                processor = new JavaToProcessor();
                processor.setEnvironment(env);
                processor.process();
            }
        }
        catch (ToolException ex) {
            if (ex.getCause() instanceof BadUsageException) {
                this.printUsageException(TOOL_NAME, (BadUsageException)ex.getCause());
                if (this.isVerboseOn()) {
                    ex.printStackTrace();
                }
            }
            throw ex;
        }
        catch (Exception ex) {
            System.err.println("Error: " + ex.getMessage());
            System.err.println();
            if (this.isVerboseOn()) {
                ex.printStackTrace();
            }
            throw new ToolException(ex.getMessage(), ex.getCause());
        }
        finally {
            this.tearDown();
        }
    }

    public Class getServiceClass(ToolContext context) {
        return AnnotationUtil.loadClass((String)context.get("classname"), this.getClass().getClassLoader());
    }

    public void checkParams(ErrorVisitor errors) throws ToolException {
        if (errors.getErrors().size() > 0) {
            Message msg = new Message("PARAMETER_MISSING", LOG, new Object[0]);
            throw new ToolException(msg, (Throwable)new BadUsageException(this.getUsage(), errors));
        }
    }
}

