/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.staxutils;

import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.common.util.StringUtils;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;

public class StreamWriterContentHandler
implements ContentHandler {
    XMLStreamWriter writer;
    Map<String, String> mapping = new LinkedHashMap<String, String>();

    public StreamWriterContentHandler(XMLStreamWriter w) {
        this.writer = w;
    }

    public void endDocument() throws SAXException {
    }

    public void startDocument() throws SAXException {
    }

    public void characters(char[] ch, int start, int length) throws SAXException {
        try {
            this.writer.writeCharacters(ch, start, length);
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
    }

    public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
    }

    public void endPrefixMapping(String prefix) throws SAXException {
    }

    public void skippedEntity(String name) throws SAXException {
    }

    public void setDocumentLocator(Locator locator) {
    }

    public void processingInstruction(String target, String data) throws SAXException {
    }

    public void startPrefixMapping(String prefix, String uri) throws SAXException {
        this.mapping.put(prefix, uri);
        try {
            this.writer.setPrefix(prefix, uri);
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        try {
            this.writer.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
    }

    private String getPrefix(String ns, String namespaceURI) {
        int idx = ns.indexOf(58);
        if (idx != -1) {
            return ns.substring(0, idx);
        }
        if (namespaceURI != null && namespaceURI.length() > 0) {
            return "";
        }
        return null;
    }

    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
        try {
            String prefix = this.getPrefix(qName, namespaceURI);
            if (prefix == null) {
                this.writer.writeStartElement(namespaceURI, localName);
            } else {
                this.writer.writeStartElement(prefix, localName, namespaceURI);
            }
            for (Map.Entry<String, String> e : this.mapping.entrySet()) {
                if ("".equals(e.getKey())) {
                    this.writer.writeDefaultNamespace(e.getValue());
                    continue;
                }
                this.writer.writeNamespace(e.getKey(), e.getValue());
            }
            this.mapping.clear();
            if (atts != null) {
                int attCount = atts.getLength();
                for (int i = 0; i < attCount; ++i) {
                    if (StringUtils.isEmpty(atts.getURI(i))) {
                        String s = atts.getLocalName(i);
                        if (StringUtils.isEmpty(s)) {
                            s = atts.getQName(i);
                        }
                        this.writer.writeAttribute(s, atts.getValue(i));
                        continue;
                    }
                    String pfx = atts.getQName(i);
                    if (pfx.indexOf(58) != -1) {
                        pfx = pfx.substring(0, pfx.indexOf(58));
                        this.writer.writeAttribute(pfx, atts.getURI(i), atts.getLocalName(i), atts.getValue(i));
                        continue;
                    }
                    this.writer.writeAttribute(atts.getURI(i), atts.getLocalName(i), atts.getValue(i));
                }
            }
        }
        catch (XMLStreamException e) {
            throw new SAXException(e);
        }
    }
}

