/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.client;

import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.jaxrs.client.AbstractClient;
import org.apache.cxf.jaxrs.client.ClientConfiguration;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.transport.MessageObserver;

class ClientMessageObserver
implements MessageObserver {
    private ClientConfiguration cfg;
    private ClassLoader loader;

    public ClientMessageObserver(ClientConfiguration cfg) {
        this.cfg = cfg;
        this.loader = (ClassLoader)cfg.getBus().getExtension(ClassLoader.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onMessage(Message m) {
        Message message = this.cfg.getConduitSelector().getEndpoint().getBinding().createMessage(m);
        message.put((Object)"org.apache.cxf.client", (Object)Boolean.TRUE);
        message.put((Object)"org.apache.cxf.message.inbound", (Object)Boolean.TRUE);
        PhaseInterceptorChain chain = AbstractClient.setupInInterceptorChain(this.cfg);
        message.setInterceptorChain((InterceptorChain)chain);
        message.getExchange().setInMessage(message);
        Bus origBus = BusFactory.getThreadDefaultBus((boolean)false);
        BusFactory.setThreadDefaultBus((Bus)this.cfg.getBus());
        ClassLoaderUtils.ClassLoaderHolder origLoader = null;
        try {
            if (this.loader != null) {
                origLoader = ClassLoaderUtils.setThreadContextClassloader((ClassLoader)this.loader);
            }
            chain.doIntercept(message);
        }
        finally {
            BusFactory.setThreadDefaultBus((Bus)origBus);
            if (origLoader != null) {
                origLoader.reset();
            }
        }
    }
}

