/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.x.discovery.server.contexts;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import org.apache.curator.x.discovery.ProviderStrategy;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.apache.curator.x.discovery.server.rest.DiscoveryContext;

@Provider
public class IntegerDiscoveryContext
implements DiscoveryContext<Integer>,
ContextResolver<DiscoveryContext<Integer>> {
    private final ServiceDiscovery<Integer> serviceDiscovery;
    private final ProviderStrategy<Integer> providerStrategy;
    private final int instanceRefreshMs;

    public IntegerDiscoveryContext(ServiceDiscovery<Integer> serviceDiscovery, ProviderStrategy<Integer> providerStrategy, int instanceRefreshMs) {
        this.serviceDiscovery = serviceDiscovery;
        this.providerStrategy = providerStrategy;
        this.instanceRefreshMs = instanceRefreshMs;
    }

    @Override
    public ProviderStrategy<Integer> getProviderStrategy() {
        return this.providerStrategy;
    }

    @Override
    public int getInstanceRefreshMs() {
        return this.instanceRefreshMs;
    }

    @Override
    public ServiceDiscovery<Integer> getServiceDiscovery() {
        return this.serviceDiscovery;
    }

    @Override
    public void marshallJson(ObjectNode node, String fieldName, Integer payload) throws Exception {
        if (payload != null) {
            node.put(fieldName, payload.toString());
        }
    }

    @Override
    public Integer unMarshallJson(JsonNode node) throws Exception {
        if (node != null) {
            return Integer.parseInt(node.asText());
        }
        return null;
    }

    public DiscoveryContext<Integer> getContext(Class<?> type) {
        return this;
    }
}

