/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.x.discovery.server.entity;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.curator.shaded.com.google.common.collect.Lists;
import org.apache.curator.utils.ThreadUtils;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.curator.x.discovery.server.entity.JsonServiceInstanceMarshaller;
import org.apache.curator.x.discovery.server.entity.ServiceInstances;
import org.apache.curator.x.discovery.server.rest.DiscoveryContext;

@Provider
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class JsonServiceInstancesMarshaller<T>
implements MessageBodyReader<ServiceInstances<T>>,
MessageBodyWriter<ServiceInstances<T>> {
    private final DiscoveryContext<T> context;

    public JsonServiceInstancesMarshaller(DiscoveryContext<T> context) {
        this.context = context;
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.isWriteable(type, genericType, annotations, mediaType);
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return ServiceInstances.class.isAssignableFrom(type) && mediaType.equals((Object)MediaType.APPLICATION_JSON_TYPE);
    }

    public long getSize(ServiceInstances<T> serviceInstances, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public ServiceInstances<T> readFrom(Class<ServiceInstances<T>> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        try {
            ArrayList instances = Lists.newArrayList();
            ObjectMapper mapper = new ObjectMapper();
            JsonNode tree = mapper.reader().readTree(entityStream);
            for (int i = 0; i < tree.size(); ++i) {
                JsonNode node = tree.get(i);
                ServiceInstance<T> instance = JsonServiceInstanceMarshaller.readInstance(node, this.context);
                instances.add(instance);
            }
            return new ServiceInstances(instances);
        }
        catch (Exception e) {
            ThreadUtils.checkInterrupted((Throwable)e);
            throw new WebApplicationException((Throwable)e);
        }
    }

    public void writeTo(ServiceInstances<T> serviceInstances, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode arrayNode = mapper.createArrayNode();
        List<ServiceInstance<T>> instanceList = serviceInstances.getServices();
        for (ServiceInstance<T> instance : instanceList) {
            ObjectNode node = JsonServiceInstanceMarshaller.writeInstance(mapper, instance, this.context);
            arrayNode.add((JsonNode)node);
        }
        mapper.writer().writeValue(entityStream, (Object)arrayNode);
    }
}

