/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.x.discovery.server.contexts;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.reflect.TypeToken;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import org.apache.curator.x.discovery.ProviderStrategy;
import org.apache.curator.x.discovery.ServiceDiscovery;
import org.apache.curator.x.discovery.server.rest.DiscoveryContext;

@Provider
public class GenericDiscoveryContext<T>
implements DiscoveryContext<T>,
ContextResolver<DiscoveryContext<T>> {
    private final ServiceDiscovery<T> serviceDiscovery;
    private final ProviderStrategy<T> providerStrategy;
    private final int instanceRefreshMs;
    private final TypeToken<T> payloadType;

    public GenericDiscoveryContext(ServiceDiscovery<T> serviceDiscovery, ProviderStrategy<T> providerStrategy, int instanceRefreshMs, Class<T> payloadType) {
        this(serviceDiscovery, providerStrategy, instanceRefreshMs, TypeToken.of(payloadType));
    }

    public GenericDiscoveryContext(ServiceDiscovery<T> serviceDiscovery, ProviderStrategy<T> providerStrategy, int instanceRefreshMs, TypeToken<T> payloadType) {
        this.serviceDiscovery = serviceDiscovery;
        this.providerStrategy = providerStrategy;
        this.instanceRefreshMs = instanceRefreshMs;
        this.payloadType = payloadType;
    }

    @Override
    public ProviderStrategy<T> getProviderStrategy() {
        return this.providerStrategy;
    }

    @Override
    public int getInstanceRefreshMs() {
        return this.instanceRefreshMs;
    }

    @Override
    public ServiceDiscovery<T> getServiceDiscovery() {
        return this.serviceDiscovery;
    }

    @Override
    public void marshallJson(ObjectNode node, String fieldName, T payload) throws Exception {
        if (payload == null) {
            payload = this.payloadType.getRawType().newInstance();
        }
        node.putPOJO(fieldName, payload);
    }

    @Override
    public T unMarshallJson(JsonNode node) throws Exception {
        ObjectMapper mapper = new ObjectMapper();
        Object payload = mapper.readValue(node.toString(), this.payloadType.getRawType());
        return (T)payload;
    }

    public DiscoveryContext<T> getContext(Class<?> type) {
        return this;
    }
}

