/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.x.discovery.server.rest;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.apache.curator.utils.ThreadUtils;
import org.apache.curator.x.discovery.ServiceInstance;
import org.apache.curator.x.discovery.details.InstanceProvider;
import org.apache.curator.x.discovery.server.entity.ServiceInstances;
import org.apache.curator.x.discovery.server.entity.ServiceNames;
import org.apache.curator.x.discovery.server.rest.DiscoveryContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DiscoveryResource<T> {
    private static final Logger log = LoggerFactory.getLogger(DiscoveryResource.class);
    private final DiscoveryContext<T> context;

    public DiscoveryResource(DiscoveryContext<T> context) {
        this.context = context;
    }

    @PUT
    @Path(value="v1/service/{name}/{id}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response putService(ServiceInstance<T> instance, @PathParam(value="name") String name, @PathParam(value="id") String id) {
        if (!instance.getId().equals(id) || !instance.getName().equals(name)) {
            log.info("Request where path id and/or name doesn't match entity");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        if (instance.getServiceType().isDynamic()) {
            log.info("Service type cannot be dynamic");
            return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
        }
        try {
            this.context.getServiceDiscovery().registerService(instance);
        }
        catch (Exception e) {
            ThreadUtils.checkInterrupted((Throwable)e);
            log.error("Trying to register service", (Throwable)e);
            return Response.serverError().build();
        }
        return Response.status((Response.Status)Response.Status.CREATED).build();
    }

    @DELETE
    @Path(value="v1/service/{name}/{id}")
    public Response removeService(@PathParam(value="name") String name, @PathParam(value="id") String id) {
        try {
            ServiceInstance instance = this.context.getServiceDiscovery().queryForInstance(name, id);
            if (instance != null) {
                this.context.getServiceDiscovery().unregisterService(instance);
            }
        }
        catch (Exception e) {
            ThreadUtils.checkInterrupted((Throwable)e);
            log.error("Trying to delete service", (Throwable)e);
            return Response.serverError().build();
        }
        return Response.ok().build();
    }

    @Deprecated
    @GET
    @Path(value="{name}/{id}")
    @Produces(value={"application/json"})
    public Response getDeprecated(@PathParam(value="name") String name, @PathParam(value="id") String id) {
        return this.internalGet(name, id, true);
    }

    @GET
    @Path(value="v1/service/{name}/{id}")
    @Produces(value={"application/json"})
    public Response get(@PathParam(value="name") String name, @PathParam(value="id") String id) {
        return this.internalGet(name, id, false);
    }

    @GET
    @Path(value="v1/service")
    @Produces(value={"application/json"})
    public Response getAllNames() {
        try {
            ArrayList instances = Lists.newArrayList((Iterable)this.context.getServiceDiscovery().queryForNames());
            Collections.sort(instances);
            return Response.ok((Object)new ServiceNames(instances)).build();
        }
        catch (Exception e) {
            log.error("Trying to get service names", (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="v1/service/{name}")
    @Produces(value={"application/json"})
    public Response getAll(@PathParam(value="name") String name) {
        try {
            Collection instances = this.context.getServiceDiscovery().queryForInstances(name);
            return Response.ok(new ServiceInstances(instances)).build();
        }
        catch (Exception e) {
            ThreadUtils.checkInterrupted((Throwable)e);
            log.error(String.format("Trying to get instances from service (%s)", name), (Throwable)e);
            return Response.serverError().build();
        }
    }

    @GET
    @Path(value="v1/anyservice/{name}")
    @Produces(value={"application/json"})
    public Response getAny(@PathParam(value="name") String name) {
        try {
            final ArrayList instances = Lists.newArrayList((Iterable)this.context.getServiceDiscovery().queryForInstances(name));
            ServiceInstance randomInstance = this.context.getProviderStrategy().getInstance(new InstanceProvider<T>(){

                public List<ServiceInstance<T>> getInstances() throws Exception {
                    return instances;
                }
            });
            if (randomInstance == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            return Response.ok((Object)randomInstance).build();
        }
        catch (Exception e) {
            ThreadUtils.checkInterrupted((Throwable)e);
            log.error(String.format("Trying to get any instance from service (%s)", name), (Throwable)e);
            return Response.serverError().build();
        }
    }

    private Response internalGet(String name, String id, boolean addDeprecationHeader) {
        try {
            ServiceInstance instance = this.context.getServiceDiscovery().queryForInstance(name, id);
            if (instance == null) {
                return Response.status((Response.Status)Response.Status.NOT_FOUND).build();
            }
            Response.ResponseBuilder builder = Response.ok((Object)instance);
            if (addDeprecationHeader) {
                builder = builder.header("Warning", (Object)"This API has been deprecated. Please see the updated spec for the replacement API.");
            }
            return builder.build();
        }
        catch (Exception e) {
            ThreadUtils.checkInterrupted((Throwable)e);
            log.error(String.format("Trying to get instance (%s) from service (%s)", id, name), (Throwable)e);
            return Response.serverError().build();
        }
    }
}

