/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.x.discovery.server.entity;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import javax.ws.rs.Consumes;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import javax.ws.rs.ext.Provider;
import org.apache.curator.x.discovery.server.entity.ServiceNames;
import org.codehaus.jackson.JsonNode;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.node.ArrayNode;
import org.codehaus.jackson.node.ObjectNode;

@Provider
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class JsonServiceNamesMarshaller
implements MessageBodyReader<ServiceNames>,
MessageBodyWriter<ServiceNames> {
    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return JsonServiceNamesMarshaller.allow(type, mediaType);
    }

    public ServiceNames readFrom(Class<ServiceNames> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        ArrayList names = Lists.newArrayList();
        ObjectMapper mapper = new ObjectMapper();
        JsonNode tree = mapper.reader().readTree(entityStream);
        for (int i = 0; i < tree.size(); ++i) {
            JsonNode node = tree.get(i);
            names.add(node.get("name").asText());
        }
        return new ServiceNames(names);
    }

    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return JsonServiceNamesMarshaller.allow(type, mediaType);
    }

    public long getSize(ServiceNames serviceNames, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    public void writeTo(ServiceNames serviceNames, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException, WebApplicationException {
        ObjectMapper mapper = new ObjectMapper();
        ArrayNode arrayNode = mapper.createArrayNode();
        for (String name : serviceNames.getNames()) {
            ObjectNode node = mapper.createObjectNode();
            node.put("name", name);
            arrayNode.add((JsonNode)node);
        }
        mapper.writer().writeValue(entityStream, (Object)arrayNode);
    }

    private static boolean allow(Class<?> type, MediaType mediaType) {
        return ServiceNames.class.isAssignableFrom(type) && mediaType.equals((Object)MediaType.APPLICATION_JSON_TYPE);
    }
}

