/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.x.async.modeled.details;

import java.util.AbstractMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.EnsureContainers;
import org.apache.curator.framework.listen.Listenable;
import org.apache.curator.framework.listen.StandardListenerManager;
import org.apache.curator.framework.recipes.cache.CuratorCache;
import org.apache.curator.framework.recipes.cache.CuratorCacheBridge;
import org.apache.curator.framework.recipes.cache.CuratorCacheBridgeBuilder;
import org.apache.curator.framework.recipes.cache.CuratorCacheListener;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;
import org.apache.curator.framework.recipes.cache.TreeCacheListener;
import org.apache.curator.utils.ThreadUtils;
import org.apache.curator.x.async.api.CreateOption;
import org.apache.curator.x.async.modeled.ModelSerializer;
import org.apache.curator.x.async.modeled.ModelSpec;
import org.apache.curator.x.async.modeled.ZNode;
import org.apache.curator.x.async.modeled.ZPath;
import org.apache.curator.x.async.modeled.cached.ModeledCache;
import org.apache.curator.x.async.modeled.cached.ModeledCacheListener;
import org.apache.curator.x.async.modeled.details.ZNodeImpl;
import org.apache.zookeeper.data.Stat;

class ModeledCacheImpl<T>
implements TreeCacheListener,
ModeledCache<T> {
    private final CuratorCacheBridge cache;
    private final Map<ZPath, Entry<T>> entries = new ConcurrentHashMap<ZPath, Entry<T>>();
    private final ModelSerializer<T> serializer;
    private final StandardListenerManager<ModeledCacheListener<T>> listenerContainer = StandardListenerManager.standard();
    private final ZPath basePath;
    private final EnsureContainers ensureContainers;

    ModeledCacheImpl(CuratorFramework client, ModelSpec<T> modelSpec, ExecutorService executor) {
        if (!modelSpec.path().isResolved() && !modelSpec.path().isRoot() && modelSpec.path().parent().isResolved()) {
            modelSpec = modelSpec.parent();
        }
        this.basePath = modelSpec.path();
        this.serializer = modelSpec.serializer();
        CuratorCacheBridgeBuilder bridgeBuilder = CuratorCache.bridgeBuilder((CuratorFramework)client, (String)this.basePath.fullPath()).withDataNotCached().withExecutorService(executor);
        if (modelSpec.createOptions().contains((Object)CreateOption.compress)) {
            bridgeBuilder = bridgeBuilder.withOptions(new CuratorCache.Options[]{CuratorCache.Options.COMPRESSED_DATA});
        }
        this.cache = bridgeBuilder.build();
        this.cache.listenable().addListener((Object)CuratorCacheListener.builder().forTreeCache(client, (TreeCacheListener)this).build());
        this.ensureContainers = modelSpec.createOptions().contains((Object)CreateOption.createParentsIfNeeded) || modelSpec.createOptions().contains((Object)CreateOption.createParentsAsContainers) ? new EnsureContainers(client, this.basePath.fullPath()) : null;
    }

    public void start() {
        try {
            if (this.ensureContainers != null) {
                this.ensureContainers.ensure();
            }
            this.cache.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        this.cache.close();
        this.entries.clear();
    }

    @Override
    public Optional<ZNode<T>> currentData(ZPath path) {
        Entry<T> entry = this.entries.get(path);
        if (entry != null) {
            return Optional.of(new ZNodeImpl(path, entry.stat, entry.model));
        }
        return Optional.empty();
    }

    ZPath basePath() {
        return this.basePath;
    }

    Map<ZPath, ZNode<T>> currentChildren() {
        return this.currentChildren(this.basePath);
    }

    @Override
    public Map<ZPath, ZNode<T>> currentChildren(ZPath path) {
        return this.entries.entrySet().stream().filter(entry -> ((ZPath)entry.getKey()).startsWith(path)).map(entry -> new AbstractMap.SimpleEntry((ZPath)entry.getKey(), new ZNodeImpl((ZPath)entry.getKey(), ((Entry)entry.getValue()).stat, ((Entry)entry.getValue()).model))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Listenable<ModeledCacheListener<T>> listenable() {
        return this.listenerContainer;
    }

    public void childEvent(CuratorFramework client, TreeCacheEvent event) {
        try {
            this.internalChildEvent(event);
        }
        catch (Exception e) {
            ThreadUtils.checkInterrupted((Throwable)e);
            this.listenerContainer.forEach(l -> l.handleException(e));
        }
    }

    private void internalChildEvent(TreeCacheEvent event) {
        switch (event.getType()) {
            case NODE_ADDED: 
            case NODE_UPDATED: {
                ZPath path = ZPath.parse(event.getData().getPath());
                byte[] bytes = event.getData().getData();
                if (bytes == null || bytes.length <= 0) break;
                T model = this.serializer.deserialize(bytes);
                this.entries.put(path, new Entry<T>(event.getData().getStat(), model));
                ModeledCacheListener.Type type = event.getType() == TreeCacheEvent.Type.NODE_ADDED ? ModeledCacheListener.Type.NODE_ADDED : ModeledCacheListener.Type.NODE_UPDATED;
                this.accept(type, path, event.getData().getStat(), model);
                break;
            }
            case NODE_REMOVED: {
                ZPath path = ZPath.parse(event.getData().getPath());
                Entry<T> entry = this.entries.remove(path);
                T model = null;
                if (entry != null) {
                    model = entry.model;
                } else if (event.getData().getData() != null) {
                    model = this.serializer.deserialize(event.getData().getData());
                }
                if (model == null) break;
                Stat stat = entry != null ? entry.stat : event.getData().getStat();
                this.accept(ModeledCacheListener.Type.NODE_REMOVED, path, stat, model);
                break;
            }
            case INITIALIZED: {
                this.listenerContainer.forEach(ModeledCacheListener::initialized);
                break;
            }
        }
    }

    private void accept(ModeledCacheListener.Type type, ZPath path, Stat stat, T model) {
        this.listenerContainer.forEach(l -> l.accept(type, path, stat, model));
    }

    private static final class Entry<T> {
        final Stat stat;
        final T model;

        Entry(Stat stat, T model) {
            this.stat = stat;
            this.model = model;
        }
    }
}

