/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.x.async.modeled;

import java.util.List;
import java.util.concurrent.ExecutorService;
import org.apache.curator.framework.api.transaction.CuratorOp;
import org.apache.curator.framework.api.transaction.CuratorTransactionResult;
import org.apache.curator.x.async.AsyncCuratorFramework;
import org.apache.curator.x.async.AsyncStage;
import org.apache.curator.x.async.modeled.ModelSpec;
import org.apache.curator.x.async.modeled.ModeledFrameworkBuilder;
import org.apache.curator.x.async.modeled.ZNode;
import org.apache.curator.x.async.modeled.ZPath;
import org.apache.curator.x.async.modeled.cached.CachedModeledFramework;
import org.apache.curator.x.async.modeled.versioned.VersionedModeledFramework;
import org.apache.zookeeper.data.Stat;

public interface ModeledFramework<T> {
    public static <T> ModeledFramework<T> wrap(AsyncCuratorFramework client, ModelSpec<T> model) {
        return ModeledFramework.builder(client, model).build();
    }

    public static <T> ModeledFrameworkBuilder<T> builder(AsyncCuratorFramework client, ModelSpec<T> model) {
        return new ModeledFrameworkBuilder<T>(client, model);
    }

    public static <T> ModeledFrameworkBuilder<T> builder() {
        return new ModeledFrameworkBuilder();
    }

    public CachedModeledFramework<T> cached();

    public CachedModeledFramework<T> cached(ExecutorService var1);

    public VersionedModeledFramework<T> versioned();

    public AsyncCuratorFramework unwrap();

    public ModelSpec<T> modelSpec();

    public ModeledFramework<T> child(Object var1);

    public ModeledFramework<T> parent();

    public ModeledFramework<T> withPath(ZPath var1);

    public AsyncStage<String> set(T var1);

    public AsyncStage<String> set(T var1, int var2);

    public AsyncStage<String> set(T var1, Stat var2);

    public AsyncStage<String> set(T var1, Stat var2, int var3);

    public AsyncStage<T> read();

    public AsyncStage<T> read(Stat var1);

    public AsyncStage<ZNode<T>> readAsZNode();

    public AsyncStage<Stat> update(T var1);

    public AsyncStage<Stat> update(T var1, int var2);

    public AsyncStage<Void> delete();

    public AsyncStage<Void> delete(int var1);

    public AsyncStage<Stat> checkExists();

    public AsyncStage<List<ZPath>> children();

    public AsyncStage<List<ZNode<T>>> childrenAsZNodes();

    public CuratorOp createOp(T var1);

    public CuratorOp updateOp(T var1);

    public CuratorOp updateOp(T var1, int var2);

    public CuratorOp deleteOp();

    public CuratorOp deleteOp(int var1);

    public CuratorOp checkExistsOp();

    public CuratorOp checkExistsOp(int var1);

    public AsyncStage<List<CuratorTransactionResult>> inTransaction(List<CuratorOp> var1);
}

