/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.x.async.details;

import java.util.List;
import org.apache.curator.framework.imps.CuratorFrameworkImpl;
import org.apache.curator.framework.imps.GetChildrenBuilderImpl;
import org.apache.curator.x.async.AsyncStage;
import org.apache.curator.x.async.WatchMode;
import org.apache.curator.x.async.api.AsyncGetChildrenBuilder;
import org.apache.curator.x.async.api.AsyncPathable;
import org.apache.curator.x.async.details.BackgroundProcs;
import org.apache.curator.x.async.details.BuilderCommon;
import org.apache.curator.x.async.details.Filters;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;

class AsyncGetChildrenBuilderImpl
implements AsyncGetChildrenBuilder {
    private final CuratorFrameworkImpl client;
    private final Filters filters;
    private final WatchMode watchMode;
    private Stat stat = null;

    AsyncGetChildrenBuilderImpl(CuratorFrameworkImpl client, Filters filters, WatchMode watchMode) {
        this.client = client;
        this.filters = filters;
        this.watchMode = watchMode;
    }

    @Override
    public AsyncStage<List<String>> forPath(String path) {
        BuilderCommon<List<String>> common = new BuilderCommon<List<String>>(this.filters, this.watchMode, BackgroundProcs.childrenProc);
        GetChildrenBuilderImpl builder = new GetChildrenBuilderImpl(this.client, (Watcher)common.watcher, common.backgrounding, this.stat);
        return BackgroundProcs.safeCall(common.internalCallback, () -> builder.forPath(path));
    }

    @Override
    public AsyncPathable<AsyncStage<List<String>>> storingStatIn(Stat stat) {
        this.stat = stat;
        return this;
    }
}

