/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.x.async.details;

import java.util.Objects;
import java.util.Optional;
import org.apache.curator.x.async.AsyncResult;
import org.apache.zookeeper.KeeperException;

public class AsyncResultImpl<T>
implements AsyncResult<T> {
    private final T value;
    private final KeeperException.Code code;
    private final Throwable exception;

    public AsyncResultImpl() {
        this(null, KeeperException.Code.OK, null);
    }

    public AsyncResultImpl(KeeperException.Code code) {
        this(null, code, null);
    }

    public AsyncResultImpl(T value) {
        this(value, KeeperException.Code.OK, null);
    }

    public AsyncResultImpl(Throwable exception) {
        this(null, KeeperException.Code.SYSTEMERROR, exception);
    }

    private AsyncResultImpl(T value, KeeperException.Code code, Throwable exception) {
        this.value = value;
        this.exception = exception;
        this.code = Objects.requireNonNull(code, "error cannot be null");
    }

    @Override
    public T getRawValue() {
        return this.value;
    }

    @Override
    public Optional<T> getValue() {
        return Optional.ofNullable(this.value);
    }

    @Override
    public KeeperException.Code getCode() {
        return this.code;
    }

    @Override
    public Throwable getRawException() {
        return this.exception;
    }

    @Override
    public Optional<Throwable> getException() {
        return Optional.ofNullable(this.exception);
    }

    @Override
    public void checkException() {
        if (this.exception != null) {
            throw new RuntimeException(this.exception);
        }
    }

    @Override
    public void checkError() {
        this.checkException();
        if (this.code != KeeperException.Code.OK) {
            throw new RuntimeException((Throwable)KeeperException.create((KeeperException.Code)this.code));
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AsyncResultImpl that = (AsyncResultImpl)o;
        if (this.value != null ? !this.value.equals(that.value) : that.value != null) {
            return false;
        }
        if (this.code != that.code) {
            return false;
        }
        return this.exception != null ? this.exception.equals(that.exception) : that.exception == null;
    }

    public int hashCode() {
        int result = this.value != null ? this.value.hashCode() : 0;
        result = 31 * result + this.code.hashCode();
        result = 31 * result + (this.exception != null ? this.exception.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "AsyncResult{value=" + this.value + ", code=" + this.code + ", exception=" + this.exception + '}';
    }
}

