/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.x.async.details;

import org.apache.curator.framework.imps.CuratorFrameworkImpl;
import org.apache.curator.framework.imps.GetDataBuilderImpl;
import org.apache.curator.x.async.AsyncStage;
import org.apache.curator.x.async.WatchMode;
import org.apache.curator.x.async.api.AsyncGetDataBuilder;
import org.apache.curator.x.async.api.AsyncPathable;
import org.apache.curator.x.async.details.BackgroundProcs;
import org.apache.curator.x.async.details.BuilderCommon;
import org.apache.curator.x.async.details.Filters;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;

class AsyncGetDataBuilderImpl
implements AsyncGetDataBuilder {
    private final CuratorFrameworkImpl client;
    private final Filters filters;
    private final WatchMode watchMode;
    private boolean decompressed = false;
    private Stat stat = null;

    AsyncGetDataBuilderImpl(CuratorFrameworkImpl client, Filters filters, WatchMode watchMode) {
        this.client = client;
        this.filters = filters;
        this.watchMode = watchMode;
    }

    @Override
    public AsyncPathable<AsyncStage<byte[]>> decompressed() {
        this.decompressed = true;
        return this;
    }

    @Override
    public AsyncPathable<AsyncStage<byte[]>> storingStatIn(Stat stat) {
        this.stat = stat;
        return this;
    }

    @Override
    public AsyncPathable<AsyncStage<byte[]>> decompressedStoringStatIn(Stat stat) {
        this.decompressed = true;
        this.stat = stat;
        return this;
    }

    @Override
    public AsyncStage<byte[]> forPath(String path) {
        BuilderCommon<byte[]> common = new BuilderCommon<byte[]>(this.filters, this.watchMode, BackgroundProcs.dataProc);
        GetDataBuilderImpl builder = new GetDataBuilderImpl(this.client, this.stat, (Watcher)common.watcher, common.backgrounding, this.decompressed);
        return BackgroundProcs.safeCall(common.internalCallback, () -> builder.forPath(path));
    }
}

