/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.x.async;

import java.util.Optional;
import java.util.concurrent.CompletionStage;
import org.apache.curator.x.async.AsyncStage;
import org.apache.curator.x.async.details.AsyncResultImpl;
import org.apache.zookeeper.KeeperException;

public interface AsyncResult<T> {
    public static <T> CompletionStage<AsyncResult<T>> of(AsyncStage<T> stage) {
        return stage.handle((value, ex) -> {
            if (ex != null) {
                if (ex instanceof KeeperException) {
                    return new AsyncResultImpl(((KeeperException)ex).code());
                }
                return new AsyncResultImpl((Throwable)ex);
            }
            return new AsyncResultImpl<Object>(value);
        });
    }

    public T getRawValue();

    public Optional<T> getValue();

    public KeeperException.Code getCode();

    public Throwable getRawException();

    public Optional<Throwable> getException();

    public void checkException();

    public void checkError();
}

