/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.x.async;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.apache.curator.framework.recipes.locks.InterProcessLock;
import org.apache.curator.shaded.com.google.common.base.Throwables;
import org.apache.curator.shaded.com.google.common.collect.Maps;
import org.apache.curator.utils.ThreadUtils;
import org.apache.curator.utils.ZKPaths;
import org.apache.curator.x.async.AsyncCuratorFramework;
import org.apache.curator.x.async.AsyncStage;
import org.apache.curator.x.async.api.ExistsOption;
import org.apache.zookeeper.KeeperException;

public class AsyncWrappers {
    public static CompletionStage<Map<String, byte[]>> childrenWithData(AsyncCuratorFramework client, String path) {
        return AsyncWrappers.childrenWithData(client, path, false);
    }

    public static CompletionStage<Map<String, byte[]>> childrenWithData(AsyncCuratorFramework client, String path, boolean isCompressed) {
        CompletableFuture<Map<String, byte[]>> future = new CompletableFuture<Map<String, byte[]>>();
        ((AsyncStage)client.getChildren().forPath(path)).handle((children, e) -> {
            if (e != null) {
                if (Throwables.getRootCause((Throwable)e) instanceof KeeperException.NoNodeException) {
                    future.complete(Maps.newHashMap());
                } else {
                    future.completeExceptionally((Throwable)e);
                }
            } else {
                AsyncWrappers.completeChildren(client, future, path, children, isCompressed);
            }
            return null;
        });
        return future;
    }

    public static CompletionStage<Void> asyncEnsureParents(AsyncCuratorFramework client, String path) {
        return AsyncWrappers.ensure(client, path, ExistsOption.createParentsIfNeeded);
    }

    public static CompletionStage<Void> asyncEnsureContainers(AsyncCuratorFramework client, String path) {
        return AsyncWrappers.ensure(client, path, ExistsOption.createParentsAsContainers);
    }

    public static CompletionStage<Void> lockAsync(InterProcessLock lock, long timeout, TimeUnit unit, Executor executor) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        if (executor == null) {
            CompletableFuture.runAsync(() -> AsyncWrappers.lock(future, lock, timeout, unit));
        } else {
            CompletableFuture.runAsync(() -> AsyncWrappers.lock(future, lock, timeout, unit), executor);
        }
        return future;
    }

    public static CompletionStage<Boolean> lockAsyncIf(InterProcessLock lock, long timeout, TimeUnit unit, Executor executor) {
        CompletableFuture<Boolean> future = new CompletableFuture<Boolean>();
        if (executor == null) {
            CompletableFuture.runAsync(() -> AsyncWrappers.lockIf(future, lock, timeout, unit));
        } else {
            CompletableFuture.runAsync(() -> AsyncWrappers.lockIf(future, lock, timeout, unit), executor);
        }
        return future;
    }

    public static CompletionStage<Void> lockAsync(InterProcessLock lock, Executor executor) {
        return AsyncWrappers.lockAsync(lock, 0L, null, executor);
    }

    public static CompletionStage<Void> lockAsync(InterProcessLock lock, long timeout, TimeUnit unit) {
        return AsyncWrappers.lockAsync(lock, timeout, unit, null);
    }

    public static CompletionStage<Boolean> lockAsyncIf(InterProcessLock lock, long timeout, TimeUnit unit) {
        return AsyncWrappers.lockAsyncIf(lock, timeout, unit, null);
    }

    public static CompletionStage<Void> lockAsync(InterProcessLock lock) {
        return AsyncWrappers.lockAsync(lock, 0L, null, null);
    }

    public static void release(InterProcessLock lock) {
        AsyncWrappers.release(lock, true);
    }

    public static void release(InterProcessLock lock, boolean ignoreNoLockExceptions) {
        try {
            lock.release();
        }
        catch (IllegalStateException e) {
            if (!ignoreNoLockExceptions) {
                throw new RuntimeException(e);
            }
        }
        catch (Exception e) {
            ThreadUtils.checkInterrupted((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    private static void lockIf(CompletableFuture<Boolean> future, InterProcessLock lock, long timeout, TimeUnit unit) {
        try {
            future.complete(lock.acquire(timeout, unit));
        }
        catch (Exception e) {
            ThreadUtils.checkInterrupted((Throwable)e);
            future.completeExceptionally(e);
        }
    }

    private static void lock(CompletableFuture<Void> future, InterProcessLock lock, long timeout, TimeUnit unit) {
        try {
            if (unit != null) {
                if (lock.acquire(timeout, unit)) {
                    future.complete(null);
                } else {
                    future.completeExceptionally(new TimeoutException());
                }
            } else {
                lock.acquire();
                future.complete(null);
            }
        }
        catch (Throwable e) {
            ThreadUtils.checkInterrupted((Throwable)e);
            future.completeExceptionally(e);
        }
    }

    private static void completeChildren(AsyncCuratorFramework client, CompletableFuture<Map<String, byte[]>> future, String parentPath, List<String> children, boolean isCompressed) {
        HashMap nodes = Maps.newHashMap();
        if (children.size() == 0) {
            future.complete(nodes);
            return;
        }
        children.forEach(node -> {
            String path = ZKPaths.makePath((String)parentPath, (String)node);
            AsyncStage<byte[]> stage = isCompressed ? client.getData().decompressed().forPath(path) : (AsyncStage<byte[]>)client.getData().forPath(path);
            stage.handle((data, e) -> {
                if (e != null) {
                    future.completeExceptionally((Throwable)e);
                } else {
                    nodes.put(path, data);
                    if (nodes.size() == children.size()) {
                        future.complete(nodes);
                    }
                }
                return null;
            });
        });
    }

    private static CompletionStage<Void> ensure(AsyncCuratorFramework client, String path, ExistsOption option) {
        String localPath = ZKPaths.makePath((String)path, (String)"foo");
        return client.checkExists().withOptions(Collections.singleton(option)).forPath(localPath).thenApply(__ -> null);
    }

    private AsyncWrappers() {
    }

    public static class TimeoutException
    extends RuntimeException {
    }
}

