/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.x.async.details;

import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import org.apache.curator.framework.api.CuratorWatcher;
import org.apache.curator.framework.imps.CuratorFrameworkImpl;
import org.apache.curator.framework.imps.RemoveWatchesBuilderImpl;
import org.apache.curator.x.async.AsyncStage;
import org.apache.curator.x.async.api.AsyncPathable;
import org.apache.curator.x.async.api.AsyncRemoveWatchesBuilder;
import org.apache.curator.x.async.api.RemoveWatcherOption;
import org.apache.curator.x.async.details.BackgroundProcs;
import org.apache.curator.x.async.details.BuilderCommon;
import org.apache.curator.x.async.details.Filters;
import org.apache.zookeeper.Watcher;

class AsyncRemoveWatchesBuilderImpl
implements AsyncRemoveWatchesBuilder,
AsyncPathable<AsyncStage<Void>> {
    private final CuratorFrameworkImpl client;
    private final Filters filters;
    private Watcher.WatcherType watcherType = Watcher.WatcherType.Any;
    private Set<RemoveWatcherOption> options = Collections.emptySet();
    private Watcher watcher = null;
    private CuratorWatcher curatorWatcher = null;

    AsyncRemoveWatchesBuilderImpl(CuratorFrameworkImpl client, Filters filters) {
        this.client = client;
        this.filters = filters;
    }

    @Override
    public AsyncPathable<AsyncStage<Void>> removing(Watcher watcher) {
        this.watcher = Objects.requireNonNull(watcher, "watcher cannot be null");
        this.curatorWatcher = null;
        return this;
    }

    @Override
    public AsyncPathable<AsyncStage<Void>> removing(CuratorWatcher watcher) {
        this.curatorWatcher = Objects.requireNonNull(watcher, "watcher cannot be null");
        this.watcher = null;
        return this;
    }

    @Override
    public AsyncPathable<AsyncStage<Void>> removingAll() {
        this.curatorWatcher = null;
        this.watcher = null;
        return this;
    }

    @Override
    public AsyncPathable<AsyncStage<Void>> removing(Watcher watcher, Set<RemoveWatcherOption> options) {
        this.watcher = Objects.requireNonNull(watcher, "watcher cannot be null");
        this.options = Objects.requireNonNull(options, "options cannot be null");
        this.curatorWatcher = null;
        return this;
    }

    @Override
    public AsyncPathable<AsyncStage<Void>> removing(CuratorWatcher watcher, Set<RemoveWatcherOption> options) {
        this.curatorWatcher = Objects.requireNonNull(watcher, "watcher cannot be null");
        this.options = Objects.requireNonNull(options, "options cannot be null");
        this.watcher = null;
        return this;
    }

    @Override
    public AsyncPathable<AsyncStage<Void>> removingAll(Set<RemoveWatcherOption> options) {
        this.options = Objects.requireNonNull(options, "options cannot be null");
        this.curatorWatcher = null;
        this.watcher = null;
        return this;
    }

    @Override
    public AsyncPathable<AsyncStage<Void>> removing(Watcher watcher, Watcher.WatcherType watcherType, Set<RemoveWatcherOption> options) {
        this.watcher = Objects.requireNonNull(watcher, "watcher cannot be null");
        this.options = Objects.requireNonNull(options, "options cannot be null");
        this.watcherType = Objects.requireNonNull(watcherType, "watcherType cannot be null");
        this.curatorWatcher = null;
        return this;
    }

    @Override
    public AsyncPathable<AsyncStage<Void>> removing(CuratorWatcher watcher, Watcher.WatcherType watcherType, Set<RemoveWatcherOption> options) {
        this.curatorWatcher = Objects.requireNonNull(watcher, "watcher cannot be null");
        this.options = Objects.requireNonNull(options, "options cannot be null");
        this.watcherType = Objects.requireNonNull(watcherType, "watcherType cannot be null");
        this.watcher = null;
        return this;
    }

    @Override
    public AsyncPathable<AsyncStage<Void>> removingAll(Watcher.WatcherType watcherType, Set<RemoveWatcherOption> options) {
        this.options = Objects.requireNonNull(options, "options cannot be null");
        this.watcherType = Objects.requireNonNull(watcherType, "watcherType cannot be null");
        this.curatorWatcher = null;
        this.watcher = null;
        return this;
    }

    @Override
    public AsyncPathable<AsyncStage<Void>> removing(Watcher watcher, Watcher.WatcherType watcherType) {
        this.watcher = Objects.requireNonNull(watcher, "watcher cannot be null");
        this.watcherType = Objects.requireNonNull(watcherType, "watcherType cannot be null");
        this.curatorWatcher = null;
        return this;
    }

    @Override
    public AsyncPathable<AsyncStage<Void>> removing(CuratorWatcher watcher, Watcher.WatcherType watcherType) {
        this.curatorWatcher = Objects.requireNonNull(watcher, "watcher cannot be null");
        this.watcherType = Objects.requireNonNull(watcherType, "watcherType cannot be null");
        this.watcher = null;
        return this;
    }

    @Override
    public AsyncPathable<AsyncStage<Void>> removingAll(Watcher.WatcherType watcherType) {
        this.watcherType = Objects.requireNonNull(watcherType, "watcherType cannot be null");
        this.curatorWatcher = null;
        this.watcher = null;
        return this;
    }

    @Override
    public AsyncStage<Void> forPath(String path) {
        BuilderCommon<Void> common = new BuilderCommon<Void>(this.filters, BackgroundProcs.ignoredProc);
        RemoveWatchesBuilderImpl builder = new RemoveWatchesBuilderImpl(this.client, this.watcher, this.curatorWatcher, this.watcherType, this.options.contains((Object)RemoveWatcherOption.guaranteed), this.options.contains((Object)RemoveWatcherOption.local), this.options.contains((Object)RemoveWatcherOption.guaranteed), common.backgrounding);
        return BackgroundProcs.safeCall(common.internalCallback, () -> builder.forPath(path));
    }
}

