/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.x.async.modeled.details;

import java.util.AbstractMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.listen.Listenable;
import org.apache.curator.framework.listen.ListenerContainer;
import org.apache.curator.framework.recipes.cache.TreeCache;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;
import org.apache.curator.framework.recipes.cache.TreeCacheListener;
import org.apache.curator.utils.ThreadUtils;
import org.apache.curator.x.async.api.CreateOption;
import org.apache.curator.x.async.modeled.ModelSerializer;
import org.apache.curator.x.async.modeled.ModelSpec;
import org.apache.curator.x.async.modeled.ZNode;
import org.apache.curator.x.async.modeled.ZPath;
import org.apache.curator.x.async.modeled.cached.ModeledCache;
import org.apache.curator.x.async.modeled.cached.ModeledCacheListener;
import org.apache.curator.x.async.modeled.details.ZNodeImpl;
import org.apache.zookeeper.data.Stat;

class ModeledCacheImpl<T>
implements TreeCacheListener,
ModeledCache<T> {
    private final TreeCache cache;
    private final Map<ZPath, Entry<T>> entries = new ConcurrentHashMap<ZPath, Entry<T>>();
    private final ModelSerializer<T> serializer;
    private final ListenerContainer<ModeledCacheListener<T>> listenerContainer = new ListenerContainer();
    private final ZPath basePath;

    ModeledCacheImpl(CuratorFramework client, ModelSpec<T> modelSpec, ExecutorService executor) {
        if (!modelSpec.path().isResolved() && !modelSpec.path().isRoot() && modelSpec.path().parent().isResolved()) {
            modelSpec = modelSpec.parent();
        }
        this.basePath = modelSpec.path();
        this.serializer = modelSpec.serializer();
        this.cache = TreeCache.newBuilder((CuratorFramework)client, (String)this.basePath.fullPath()).setCacheData(false).setDataIsCompressed(modelSpec.createOptions().contains((Object)CreateOption.compress)).setExecutor(executor).setCreateParentNodes(modelSpec.createOptions().contains((Object)CreateOption.createParentsIfNeeded) || modelSpec.createOptions().contains((Object)CreateOption.createParentsAsContainers)).build();
    }

    public void start() {
        try {
            this.cache.getListenable().addListener((Object)this);
            this.cache.start();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void close() {
        this.cache.getListenable().removeListener((Object)this);
        this.cache.close();
        this.entries.clear();
    }

    @Override
    public Optional<ZNode<T>> currentData(ZPath path) {
        Entry<T> entry = this.entries.remove(path);
        if (entry != null) {
            return Optional.of(new ZNodeImpl(path, entry.stat, entry.model));
        }
        return Optional.empty();
    }

    ZPath basePath() {
        return this.basePath;
    }

    Map<ZPath, ZNode<T>> currentChildren() {
        return this.currentChildren(this.basePath);
    }

    @Override
    public Map<ZPath, ZNode<T>> currentChildren(ZPath path) {
        return this.entries.entrySet().stream().filter(entry -> ((ZPath)entry.getKey()).startsWith(path)).map(entry -> new AbstractMap.SimpleEntry(entry.getKey(), new ZNodeImpl((ZPath)entry.getKey(), ((Entry)entry.getValue()).stat, ((Entry)entry.getValue()).model))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public Listenable<ModeledCacheListener<T>> listenable() {
        return this.listenerContainer;
    }

    public void childEvent(CuratorFramework client, TreeCacheEvent event) {
        try {
            this.internalChildEvent(event);
        }
        catch (Exception e) {
            ThreadUtils.checkInterrupted((Throwable)e);
            this.listenerContainer.forEach(l -> {
                l.handleException(e);
                return null;
            });
        }
    }

    private void internalChildEvent(TreeCacheEvent event) throws Exception {
        switch (event.getType()) {
            case NODE_ADDED: 
            case NODE_UPDATED: {
                byte[] bytes;
                ZPath path = ZPath.parse(event.getData().getPath());
                if (path.equals(this.basePath) || (bytes = event.getData().getData()) == null || bytes.length <= 0) break;
                T model = this.serializer.deserialize(bytes);
                this.entries.put(path, new Entry<T>(event.getData().getStat(), model));
                ModeledCacheListener.Type type = event.getType() == TreeCacheEvent.Type.NODE_ADDED ? ModeledCacheListener.Type.NODE_ADDED : ModeledCacheListener.Type.NODE_UPDATED;
                this.accept(type, path, event.getData().getStat(), model);
                break;
            }
            case NODE_REMOVED: {
                ZPath path = ZPath.parse(event.getData().getPath());
                if (path.equals(this.basePath)) break;
                Entry<T> entry = this.entries.remove(path);
                Object model = entry != null ? entry.model : this.serializer.deserialize(event.getData().getData());
                Stat stat = entry != null ? entry.stat : event.getData().getStat();
                this.accept(ModeledCacheListener.Type.NODE_REMOVED, path, stat, model);
                break;
            }
            case INITIALIZED: {
                this.listenerContainer.forEach(l -> {
                    l.initialized();
                    return null;
                });
                break;
            }
        }
    }

    private void accept(ModeledCacheListener.Type type, ZPath path, Stat stat, T model) {
        this.listenerContainer.forEach(l -> {
            l.accept(type, path, stat, model);
            return null;
        });
    }

    private static final class Entry<T> {
        final Stat stat;
        final T model;

        Entry(Stat stat, T model) {
            this.stat = stat;
            this.model = model;
        }
    }
}

