/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.x.async.details;

import java.util.List;
import java.util.Objects;
import org.apache.curator.framework.api.ACLCreateModePathAndBytesable;
import org.apache.curator.framework.api.PathAndBytesable;
import org.apache.curator.framework.api.Pathable;
import org.apache.curator.framework.api.VersionPathAndBytesable;
import org.apache.curator.framework.api.transaction.CuratorOp;
import org.apache.curator.framework.api.transaction.TransactionCreateBuilder;
import org.apache.curator.framework.api.transaction.TransactionSetDataBuilder;
import org.apache.curator.framework.imps.CuratorFrameworkImpl;
import org.apache.curator.x.async.api.AsyncPathAndBytesable;
import org.apache.curator.x.async.api.AsyncPathable;
import org.apache.curator.x.async.api.AsyncTransactionCheckBuilder;
import org.apache.curator.x.async.api.AsyncTransactionCreateBuilder;
import org.apache.curator.x.async.api.AsyncTransactionDeleteBuilder;
import org.apache.curator.x.async.api.AsyncTransactionOp;
import org.apache.curator.x.async.api.AsyncTransactionSetDataBuilder;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.data.ACL;

class AsyncTransactionOpImpl
implements AsyncTransactionOp {
    private final CuratorFrameworkImpl client;

    AsyncTransactionOpImpl(CuratorFrameworkImpl client) {
        this.client = client;
    }

    @Override
    public AsyncTransactionCreateBuilder create() {
        return new AsyncTransactionCreateBuilder(){
            private List<ACL> aclList = null;
            private CreateMode createMode = CreateMode.PERSISTENT;
            private boolean compressed = false;

            @Override
            public AsyncPathable<CuratorOp> withMode(CreateMode createMode) {
                this.createMode = Objects.requireNonNull(createMode, "createMode cannot be null");
                return this;
            }

            @Override
            public AsyncPathable<CuratorOp> withACL(List<ACL> aclList) {
                this.aclList = aclList;
                return this;
            }

            @Override
            public AsyncPathable<CuratorOp> compressed() {
                this.compressed = true;
                return this;
            }

            @Override
            public AsyncPathable<CuratorOp> withOptions(CreateMode createMode, List<ACL> aclList, boolean compressed) {
                this.createMode = Objects.requireNonNull(createMode, "createMode cannot be null");
                this.aclList = aclList;
                this.compressed = compressed;
                return this;
            }

            @Override
            public CuratorOp forPath(String path, byte[] data) {
                return this.internalForPath(path, data, true);
            }

            @Override
            public CuratorOp forPath(String path) {
                return this.internalForPath(path, null, false);
            }

            private CuratorOp internalForPath(String path, byte[] data, boolean useData) {
                TransactionCreateBuilder builder1 = AsyncTransactionOpImpl.this.client.transactionOp().create();
                TransactionCreateBuilder builder2 = this.compressed ? (ACLCreateModePathAndBytesable)builder1.compressed() : builder1;
                PathAndBytesable builder3 = (PathAndBytesable)builder2.withACL(this.aclList);
                try {
                    return useData ? (CuratorOp)builder3.forPath(path, data) : (CuratorOp)builder3.forPath(path);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    @Override
    public AsyncTransactionDeleteBuilder delete() {
        return new AsyncTransactionDeleteBuilder(){
            private int version = -1;

            @Override
            public AsyncPathable<CuratorOp> withVersion(int version) {
                this.version = version;
                return this;
            }

            @Override
            public CuratorOp forPath(String path) {
                try {
                    return (CuratorOp)((Pathable)AsyncTransactionOpImpl.this.client.transactionOp().delete().withVersion(this.version)).forPath(path);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    @Override
    public AsyncTransactionSetDataBuilder setData() {
        return new AsyncTransactionSetDataBuilder(){
            private int version = -1;
            private boolean compressed = false;

            @Override
            public AsyncPathAndBytesable<CuratorOp> withVersion(int version) {
                this.version = version;
                return this;
            }

            @Override
            public AsyncPathAndBytesable<CuratorOp> compressed() {
                this.compressed = true;
                return this;
            }

            @Override
            public AsyncPathAndBytesable<CuratorOp> withVersionCompressed(int version) {
                this.version = version;
                this.compressed = true;
                return this;
            }

            @Override
            public CuratorOp forPath(String path, byte[] data) {
                return this.internalForPath(path, data, true);
            }

            @Override
            public CuratorOp forPath(String path) {
                return this.internalForPath(path, null, false);
            }

            private CuratorOp internalForPath(String path, byte[] data, boolean useData) {
                TransactionSetDataBuilder builder1 = AsyncTransactionOpImpl.this.client.transactionOp().setData();
                TransactionSetDataBuilder builder2 = this.compressed ? (VersionPathAndBytesable)builder1.compressed() : builder1;
                PathAndBytesable builder3 = (PathAndBytesable)builder2.withVersion(this.version);
                try {
                    return useData ? (CuratorOp)builder3.forPath(path, data) : (CuratorOp)builder3.forPath(path);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }

    @Override
    public AsyncTransactionCheckBuilder check() {
        return new AsyncTransactionCheckBuilder(){
            private int version = -1;

            @Override
            public AsyncPathable<CuratorOp> withVersion(int version) {
                this.version = version;
                return this;
            }

            @Override
            public CuratorOp forPath(String path) {
                try {
                    return (CuratorOp)((Pathable)AsyncTransactionOpImpl.this.client.transactionOp().check().withVersion(this.version)).forPath(path);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
    }
}

