/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.test;

import java.io.File;
import java.io.IOException;
import org.apache.curator-test.shaded.com.google.common.base.Preconditions;

public class DirectoryUtils {
    public static void deleteRecursively(File file) throws IOException {
        if (file.isDirectory()) {
            DirectoryUtils.deleteDirectoryContents(file);
        }
        if (!file.delete()) {
            throw new IOException("Failed to delete " + file);
        }
    }

    public static void deleteDirectoryContents(File directory) throws IOException {
        Preconditions.checkArgument(directory.isDirectory(), "Not a directory: %s", directory);
        File[] files = directory.listFiles();
        if (files == null) {
            throw new IOException("Error listing files for " + directory);
        }
        for (File file : files) {
            DirectoryUtils.deleteRecursively(file);
        }
    }
}

