/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.test;

import java.io.Closeable;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.curator-test.shaded.com.google.common.base.Function;
import org.apache.curator-test.shaded.com.google.common.base.Preconditions;
import org.apache.curator-test.shaded.com.google.common.collect.ImmutableList;
import org.apache.curator-test.shaded.com.google.common.collect.ImmutableMap;
import org.apache.curator-test.shaded.com.google.common.collect.Iterables;
import org.apache.curator-test.shaded.com.google.common.collect.Lists;
import org.apache.curator.test.ByteCodeRewrite;
import org.apache.curator.test.InstanceSpec;
import org.apache.curator.test.QuorumConfigBuilder;
import org.apache.curator.test.TestingZooKeeperServer;
import org.apache.zookeeper.ZooKeeper;

public class TestingCluster
implements Closeable {
    private final List<TestingZooKeeperServer> servers;

    public TestingCluster(int instanceQty) {
        this(TestingCluster.makeSpecs(instanceQty));
    }

    public TestingCluster(InstanceSpec ... specs) {
        this(TestingCluster.listToMap(ImmutableList.copyOf(specs)));
    }

    public TestingCluster(Collection<InstanceSpec> specs) {
        this(TestingCluster.listToMap(specs));
    }

    public TestingCluster(Map<InstanceSpec, Collection<InstanceSpec>> specs) {
        ImmutableList.Builder serverBuilder = ImmutableList.builder();
        for (Map.Entry<InstanceSpec, Collection<InstanceSpec>> entry : specs.entrySet()) {
            ArrayList<InstanceSpec> instanceSpecs = Lists.newArrayList((Iterable)entry.getValue());
            int index = instanceSpecs.indexOf(entry.getKey());
            Preconditions.checkState(index >= 0, entry.getKey() + " not found in specs");
            QuorumConfigBuilder builder = new QuorumConfigBuilder(instanceSpecs);
            serverBuilder.add(new TestingZooKeeperServer(builder, index));
        }
        this.servers = serverBuilder.build();
    }

    public Collection<InstanceSpec> getInstances() {
        Iterable<InstanceSpec> transformed = Iterables.transform(this.servers, new Function<TestingZooKeeperServer, InstanceSpec>(){

            @Override
            public InstanceSpec apply(TestingZooKeeperServer server) {
                return server.getInstanceSpec();
            }
        });
        return Lists.newArrayList(transformed);
    }

    public List<TestingZooKeeperServer> getServers() {
        return Lists.newArrayList(this.servers);
    }

    public String getConnectString() {
        StringBuilder str = new StringBuilder();
        for (InstanceSpec spec : this.getInstances()) {
            if (str.length() > 0) {
                str.append(",");
            }
            str.append(spec.getConnectString());
        }
        return str.toString();
    }

    public void start() throws Exception {
        for (TestingZooKeeperServer server : this.servers) {
            server.start();
        }
    }

    public void stop() throws IOException {
        for (TestingZooKeeperServer server : this.servers) {
            server.stop();
        }
    }

    @Override
    public void close() throws IOException {
        for (TestingZooKeeperServer server : this.servers) {
            server.close();
        }
    }

    public boolean killServer(InstanceSpec instance) throws Exception {
        for (TestingZooKeeperServer server : this.servers) {
            if (!server.getInstanceSpec().equals(instance)) continue;
            server.kill();
            return true;
        }
        return false;
    }

    public boolean restartServer(InstanceSpec instance) throws Exception {
        for (TestingZooKeeperServer server : this.servers) {
            if (!server.getInstanceSpec().equals(instance)) continue;
            server.restart();
            return true;
        }
        return false;
    }

    public InstanceSpec findConnectionInstance(ZooKeeper client) throws Exception {
        Method m = client.getClass().getDeclaredMethod("testableRemoteSocketAddress", new Class[0]);
        m.setAccessible(true);
        InetSocketAddress address = (InetSocketAddress)m.invoke((Object)client, new Object[0]);
        if (address != null) {
            for (TestingZooKeeperServer server : this.servers) {
                if (server.getInstanceSpec().getPort() != address.getPort()) continue;
                return server.getInstanceSpec();
            }
        }
        return null;
    }

    private static Map<InstanceSpec, Collection<InstanceSpec>> makeSpecs(int instanceQty) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (int i = 0; i < instanceQty; ++i) {
            builder.add(InstanceSpec.newInstanceSpec());
        }
        return TestingCluster.listToMap(builder.build());
    }

    private static Map<InstanceSpec, Collection<InstanceSpec>> listToMap(Collection<InstanceSpec> list) {
        ImmutableMap.Builder<InstanceSpec, Collection<InstanceSpec>> mapBuilder = ImmutableMap.builder();
        for (InstanceSpec spec : list) {
            mapBuilder.put(spec, list);
        }
        return mapBuilder.build();
    }

    static {
        ByteCodeRewrite.apply();
    }
}

