/*
 * Decompiled with CFR 0.152.
 */
package pubsub;

import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.curator.x.async.AsyncCuratorFramework;
import org.apache.curator.x.async.modeled.ModeledFramework;
import org.apache.curator.x.async.modeled.typed.TypedModeledFramework2;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pubsub.Clients;
import pubsub.messages.LocationAvailable;
import pubsub.messages.UserCreated;
import pubsub.models.Group;
import pubsub.models.Instance;
import pubsub.models.Message;
import pubsub.models.Priority;

public class Publisher {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final AsyncCuratorFramework client;

    public Publisher(AsyncCuratorFramework client) {
        this.client = Objects.requireNonNull(client, "client cannot be null");
    }

    public void publishInstance(Instance instance) {
        ModeledFramework resolvedClient = Clients.instanceClient.resolved(this.client, (Object)instance.getType());
        resolvedClient.set((Object)instance).exceptionally(e -> {
            this.log.error("Could not publish instance: " + instance, e);
            return null;
        });
    }

    public void publishInstances(List<Instance> instances) {
        List operations = instances.stream().map(instance -> Clients.instanceClient.resolved(this.client, (Object)instance.getType()).createOp(instance)).collect(Collectors.toList());
        this.client.transaction().forOperations(operations).exceptionally(e -> {
            this.log.error("Could not publish instances: " + instances, e);
            return null;
        });
    }

    public void publishLocationAvailable(Group group, LocationAvailable locationAvailable) {
        this.publishMessage(Clients.locationAvailableClient, group, locationAvailable);
    }

    public void publishUserCreated(Group group, UserCreated userCreated) {
        this.publishMessage(Clients.userCreatedClient, group, userCreated);
    }

    public void publishLocationsAvailable(Group group, List<LocationAvailable> locationsAvailable) {
        this.publishMessages(Clients.locationAvailableClient, group, locationsAvailable);
    }

    public void publishUsersCreated(Group group, List<UserCreated> usersCreated) {
        this.publishMessages(Clients.userCreatedClient, group, usersCreated);
    }

    private <T extends Message> void publishMessage(TypedModeledFramework2<T, Group, Priority> typedClient, Group group, T message) {
        ModeledFramework resolvedClient = typedClient.resolved(this.client, (Object)group, (Object)message.getPriority());
        resolvedClient.set(message).exceptionally(e -> {
            this.log.error("Could not publish message: " + message, e);
            return null;
        });
    }

    private <T extends Message> void publishMessages(TypedModeledFramework2<T, Group, Priority> typedClient, Group group, List<T> messages) {
        List operations = messages.stream().map(message -> typedClient.resolved(this.client, (Object)group, (Object)message.getPriority()).createOp(message)).collect(Collectors.toList());
        this.client.transaction().forOperations(operations).exceptionally(e -> {
            this.log.error("Could not publish messages: " + messages, e);
            return null;
        });
    }
}

