/*
 * Decompiled with CFR 0.152.
 */
package cache;

import java.util.concurrent.ThreadLocalRandom;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.DeleteBuilderMain;
import org.apache.curator.framework.recipes.cache.CuratorCache;
import org.apache.curator.framework.recipes.cache.CuratorCacheListener;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.test.TestingServer;

public class CuratorCacheExample {
    private static final String PATH = "/example/cache";

    public static void main(String[] args) throws Exception {
        ThreadLocalRandom random = ThreadLocalRandom.current();
        try (TestingServer server = new TestingServer();
             CuratorFramework client = CuratorFrameworkFactory.newClient((String)server.getConnectString(), (RetryPolicy)new ExponentialBackoffRetry(1000, 3));){
            client.start();
            try (CuratorCache cache = CuratorCache.build((CuratorFramework)client, (String)PATH, (CuratorCache.Options[])new CuratorCache.Options[0]);){
                CuratorCacheListener listener = CuratorCacheListener.builder().forCreates(node -> System.out.println(String.format("Node created: [%s]", node))).forChanges((oldNode, node) -> System.out.println(String.format("Node changed. Old: [%s] New: [%s]", oldNode, node))).forDeletes(oldNode -> System.out.println(String.format("Node deleted. Old value: [%s]", oldNode))).forInitialized(() -> System.out.println("Cache initialized")).build();
                cache.listenable().addListener((Object)listener);
                cache.start();
                for (int i = 0; i < 1000; ++i) {
                    int depth = random.nextInt(1, 4);
                    String path = CuratorCacheExample.makeRandomPath(random, depth);
                    if (random.nextBoolean()) {
                        client.create().orSetData().creatingParentsIfNeeded().forPath(path, Long.toString(random.nextLong()).getBytes());
                    } else {
                        ((DeleteBuilderMain)client.delete().quietly()).deletingChildrenIfNeeded().forPath(path);
                    }
                    Thread.sleep(5L);
                }
            }
        }
    }

    private static String makeRandomPath(ThreadLocalRandom random, int depth) {
        if (depth == 0) {
            return PATH;
        }
        return CuratorCacheExample.makeRandomPath(random, depth - 1) + "/" + random.nextInt(3);
    }
}

