/*
 * Decompiled with CFR 0.152.
 */
package leader;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.recipes.leader.LeaderSelector;
import org.apache.curator.framework.recipes.leader.LeaderSelectorListener;
import org.apache.curator.framework.recipes.leader.LeaderSelectorListenerAdapter;

public class ExampleClient
extends LeaderSelectorListenerAdapter
implements Closeable {
    private final String name;
    private final LeaderSelector leaderSelector;
    private final AtomicInteger leaderCount = new AtomicInteger();

    public ExampleClient(CuratorFramework client, String path, String name) {
        this.name = name;
        this.leaderSelector = new LeaderSelector(client, path, (LeaderSelectorListener)this);
        this.leaderSelector.autoRequeue();
    }

    public void start() throws IOException {
        this.leaderSelector.start();
    }

    @Override
    public void close() throws IOException {
        this.leaderSelector.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void takeLeadership(CuratorFramework client) throws Exception {
        int waitSeconds = (int)(5.0 * Math.random()) + 1;
        System.out.println(this.name + " is now the leader. Waiting " + waitSeconds + " seconds...");
        System.out.println(this.name + " has been leader " + this.leaderCount.getAndIncrement() + " time(s) before.");
        try {
            Thread.sleep(TimeUnit.SECONDS.toMillis(waitSeconds));
        }
        catch (InterruptedException e) {
            System.err.println(this.name + " was interrupted.");
            Thread.currentThread().interrupt();
        }
        finally {
            System.out.println(this.name + " relinquishing leadership.\n");
        }
    }
}

