/*
 * Decompiled with CFR 0.152.
 */
package cache;

import com.google.common.collect.Lists;
import discovery.ExampleServer;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.recipes.cache.ChildData;
import org.apache.curator.framework.recipes.cache.PathChildrenCache;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheEvent;
import org.apache.curator.framework.recipes.cache.PathChildrenCacheListener;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.test.TestingServer;
import org.apache.curator.utils.CloseableUtils;
import org.apache.curator.utils.ZKPaths;
import org.apache.zookeeper.KeeperException;

public class PathCacheExample {
    private static final String PATH = "/example/cache";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        TestingServer server = new TestingServer();
        CuratorFramework client = null;
        PathChildrenCache cache = null;
        try {
            client = CuratorFrameworkFactory.newClient((String)server.getConnectString(), (RetryPolicy)new ExponentialBackoffRetry(1000, 3));
            client.start();
            cache = new PathChildrenCache(client, PATH, true);
            cache.start();
            PathCacheExample.processCommands(client, cache);
        }
        catch (Throwable throwable) {
            CloseableUtils.closeQuietly(cache);
            CloseableUtils.closeQuietly(client);
            CloseableUtils.closeQuietly((Closeable)server);
            throw throwable;
        }
        CloseableUtils.closeQuietly((Closeable)cache);
        CloseableUtils.closeQuietly((Closeable)client);
        CloseableUtils.closeQuietly((Closeable)server);
    }

    private static void addListener(PathChildrenCache cache) {
        PathChildrenCacheListener listener = new PathChildrenCacheListener(){

            public void childEvent(CuratorFramework client, PathChildrenCacheEvent event) throws Exception {
                switch (event.getType()) {
                    case CHILD_ADDED: {
                        System.out.println("Node added: " + ZKPaths.getNodeFromPath((String)event.getData().getPath()));
                        break;
                    }
                    case CHILD_UPDATED: {
                        System.out.println("Node changed: " + ZKPaths.getNodeFromPath((String)event.getData().getPath()));
                        break;
                    }
                    case CHILD_REMOVED: {
                        System.out.println("Node removed: " + ZKPaths.getNodeFromPath((String)event.getData().getPath()));
                    }
                }
            }
        };
        cache.getListenable().addListener((Object)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void processCommands(CuratorFramework client, PathChildrenCache cache) throws Exception {
        PathCacheExample.printHelp();
        ArrayList servers = Lists.newArrayList();
        try {
            PathCacheExample.addListener(cache);
            BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
            boolean done = false;
            while (!done) {
                System.out.print("> ");
                String command = in.readLine().trim();
                String[] parts = command.split("\\s");
                if (parts.length == 0) continue;
                String operation = parts[0];
                String[] args = Arrays.copyOfRange(parts, 1, parts.length);
                if (operation.equalsIgnoreCase("help") || operation.equalsIgnoreCase("?")) {
                    PathCacheExample.printHelp();
                } else if (operation.equalsIgnoreCase("q") || operation.equalsIgnoreCase("quit")) {
                    done = true;
                } else if (operation.equals("set")) {
                    PathCacheExample.setValue(client, command, args);
                } else if (operation.equals("remove")) {
                    PathCacheExample.remove(client, command, args);
                } else if (operation.equals("list")) {
                    PathCacheExample.list(cache);
                }
                Thread.sleep(1000L);
            }
        }
        finally {
            for (ExampleServer server : servers) {
                CloseableUtils.closeQuietly((Closeable)server);
            }
        }
    }

    private static void list(PathChildrenCache cache) {
        if (cache.getCurrentData().size() == 0) {
            System.out.println("* empty *");
        } else {
            for (ChildData data : cache.getCurrentData()) {
                System.out.println(data.getPath() + " = " + new String(data.getData()));
            }
        }
    }

    private static void remove(CuratorFramework client, String command, String[] args) throws Exception {
        if (args.length != 1) {
            System.err.println("syntax error (expected remove <path>): " + command);
            return;
        }
        String name = args[0];
        if (name.contains("/")) {
            System.err.println("Invalid node name" + name);
            return;
        }
        String path = ZKPaths.makePath((String)PATH, (String)name);
        try {
            client.delete().forPath(path);
        }
        catch (KeeperException.NoNodeException e) {
            // empty catch block
        }
    }

    private static void setValue(CuratorFramework client, String command, String[] args) throws Exception {
        if (args.length != 2) {
            System.err.println("syntax error (expected set <path> <value>): " + command);
            return;
        }
        String name = args[0];
        if (name.contains("/")) {
            System.err.println("Invalid node name" + name);
            return;
        }
        String path = ZKPaths.makePath((String)PATH, (String)name);
        byte[] bytes = args[1].getBytes();
        try {
            client.setData().forPath(path, bytes);
        }
        catch (KeeperException.NoNodeException e) {
            client.create().creatingParentsIfNeeded().forPath(path, bytes);
        }
    }

    private static void printHelp() {
        System.out.println("An example of using PathChildrenCache. This example is driven by entering commands at the prompt:\n");
        System.out.println("set <name> <value>: Adds or updates a node with the given name");
        System.out.println("remove <name>: Deletes the node with the given name");
        System.out.println("delete: List the nodes/values in the cache");
        System.out.println("quit: Quit the example");
        System.out.println();
    }
}

